%------------------------------------------------------------------------------
% File     : ITP012^7 : TPTP v9.2.0. Bugfixed v7.5.0.
% Domain   : Interactive Theorem Proving
% Problem  : HOL4 syntactic export of thm_2Einteger_2EINT__DIVIDES__RSUB.p, chainy mode
% Version  : [BG+19] axioms.
% English  :

% Refs     : [BG+19] Brown et al. (2019), GRUNGE: A Grand Unified ATP Chall
%          : [Gau20] Gauthier (2020), Email to Geoff Sutcliffe
% Source   : [BG+19]
% Names    : thm_2Einteger_2EINT__DIVIDES__RSUB.p [Gau20]
%          : HL405501^7.p [TPAP]

% Status   : Theorem
% Rating   : 0.33 v9.1.0, 0.67 v8.1.0, 0.50 v7.5.0
% Syntax   : Number of formulae    : 11537 (2750 unt;4010 typ;   0 def)
%            Number of atoms       : 30761 (10264 equ;1257 cnn)
%            Maximal formula atoms :  912 (   4 avg)
%            Number of connectives : 198277 (1257   ~; 701   |;7483   &;180514   @)
%                                         (3902 <=>;4420  =>;   0  <=;   0 <~>)
%            Maximal formula depth :  364 (   8 avg)
%            Number of types       :    9 (   8 usr)
%            Number of type conns  : 22786 (22786   >;   0   *;   0   +;   0  <<)
%            Number of symbols     : 1116 (1114 usr;  17 con; 0-10 aty)
%            Number of variables   : 48812 (2893   ^;29370   !;13203   ?;48812   :)
%                                         (3346  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TH1_THM_EQU_NAR

% Comments :
% Bugfixes : v7.5.0 - Bugfixes in axioms and export.
%------------------------------------------------------------------------------
include('Axioms/ITP001/ITP002^7.ax').
include('Axioms/ITP001/ITP003^7.ax').
include('Axioms/ITP001/ITP004^7.ax').
include('Axioms/ITP001/ITP005^7.ax').
include('Axioms/ITP001/ITP006^7.ax').
include('Axioms/ITP001/ITP007^7.ax').
include('Axioms/ITP001/ITP008^7.ax').
include('Axioms/ITP001/ITP009^7.ax').
include('Axioms/ITP001/ITP010^7.ax').
include('Axioms/ITP001/ITP011^7.ax').
include('Axioms/ITP001/ITP012^7.ax').
include('Axioms/ITP001/ITP013^7.ax').
include('Axioms/ITP001/ITP014^7.ax').
include('Axioms/ITP001/ITP015^7.ax').
include('Axioms/ITP001/ITP016^7.ax').
include('Axioms/ITP001/ITP017^7.ax').
include('Axioms/ITP001/ITP018^7.ax').
include('Axioms/ITP001/ITP019^7.ax').
include('Axioms/ITP001/ITP020^7.ax').
include('Axioms/ITP001/ITP021^7.ax').
include('Axioms/ITP001/ITP022^7.ax').
include('Axioms/ITP001/ITP023^7.ax').
include('Axioms/ITP001/ITP024^7.ax').
include('Axioms/ITP001/ITP025^7.ax').
include('Axioms/ITP001/ITP026^7.ax').
include('Axioms/ITP001/ITP027^7.ax').
include('Axioms/ITP001/ITP028^7.ax').
include('Axioms/ITP001/ITP029^7.ax').
include('Axioms/ITP001/ITP030^7.ax').
include('Axioms/ITP001/ITP031^7.ax').
include('Axioms/ITP001/ITP032^7.ax').
include('Axioms/ITP001/ITP033^7.ax').
include('Axioms/ITP001/ITP034^7.ax').
include('Axioms/ITP001/ITP035^7.ax').
include('Axioms/ITP001/ITP036^7.ax').
include('Axioms/ITP001/ITP037^7.ax').
include('Axioms/ITP001/ITP038^7.ax').
include('Axioms/ITP001/ITP039^7.ax').
include('Axioms/ITP001/ITP040^7.ax').
include('Axioms/ITP001/ITP041^7.ax').
include('Axioms/ITP001/ITP042^7.ax').
include('Axioms/ITP001/ITP043^7.ax').
include('Axioms/ITP001/ITP044^7.ax').
include('Axioms/ITP001/ITP045^7.ax').
include('Axioms/ITP001/ITP046^7.ax').
include('Axioms/ITP001/ITP047^7.ax').
include('Axioms/ITP001/ITP048^7.ax').
include('Axioms/ITP001/ITP049^7.ax').
include('Axioms/ITP001/ITP050^7.ax').
include('Axioms/ITP001/ITP051^7.ax').
include('Axioms/ITP001/ITP052^7.ax').
include('Axioms/ITP001/ITP053^7.ax').
include('Axioms/ITP001/ITP054^7.ax').
include('Axioms/ITP001/ITP055^7.ax').
include('Axioms/ITP001/ITP056^7.ax').
include('Axioms/ITP001/ITP057^7.ax').
include('Axioms/ITP001/ITP058^7.ax').
include('Axioms/ITP001/ITP059^7.ax').
include('Axioms/ITP001/ITP060^7.ax').
include('Axioms/ITP001/ITP061^7.ax').
include('Axioms/ITP001/ITP062^7.ax').
include('Axioms/ITP001/ITP063^7.ax').
include('Axioms/ITP001/ITP064^7.ax').
include('Axioms/ITP001/ITP065^7.ax').
include('Axioms/ITP001/ITP066^7.ax').
include('Axioms/ITP001/ITP067^7.ax').
include('Axioms/ITP001/ITP068^7.ax').
include('Axioms/ITP001/ITP069^7.ax').
include('Axioms/ITP001/ITP070^7.ax').
include('Axioms/ITP001/ITP071^7.ax').
include('Axioms/ITP001/ITP072^7.ax').
include('Axioms/ITP001/ITP073^7.ax').
include('Axioms/ITP001/ITP074^7.ax').
include('Axioms/ITP001/ITP075^7.ax').
include('Axioms/ITP001/ITP076^7.ax').
include('Axioms/ITP001/ITP077^7.ax').
include('Axioms/ITP001/ITP078^7.ax').
include('Axioms/ITP001/ITP079^7.ax').
include('Axioms/ITP001/ITP080^7.ax').
include('Axioms/ITP001/ITP081^7.ax').
include('Axioms/ITP001/ITP082^7.ax').
include('Axioms/ITP001/ITP083^7.ax').
include('Axioms/ITP001/ITP084^7.ax').
%------------------------------------------------------------------------------
thf(tyop_2Einteger_2Eint,type,
    tyop_2Einteger_2Eint: $tType ).

thf(tyop_2Emin_2Ebool,type,
    tyop_2Emin_2Ebool: $tType ).

thf(tyop_2Emin_2Efun,type,
    tyop_2Emin_2Efun: $tType > $tType > $tType ).

thf(tyop_2Enum_2Enum,type,
    tyop_2Enum_2Enum: $tType ).

thf(tyop_2Epair_2Eprod,type,
    tyop_2Epair_2Eprod: $tType > $tType > $tType ).

thf(c_2Ebool_2E_21,type,
    c_2Ebool_2E_21: 
      !>[A_27a: $tType] : ( ( A_27a > $o ) > $o ) ).

thf(c_2Earithmetic_2E_2A,type,
    c_2Earithmetic_2E_2A: tyop_2Enum_2Enum > tyop_2Enum_2Enum > tyop_2Enum_2Enum ).

thf(c_2Earithmetic_2E_2B,type,
    c_2Earithmetic_2E_2B: tyop_2Enum_2Enum > tyop_2Enum_2Enum > tyop_2Enum_2Enum ).

thf(c_2Epair_2E_2C,type,
    c_2Epair_2E_2C: 
      !>[A_27a: $tType,A_27b: $tType] : ( A_27a > A_27b > ( tyop_2Epair_2Eprod @ A_27a @ A_27b ) ) ).

thf(c_2Earithmetic_2E_2D,type,
    c_2Earithmetic_2E_2D: tyop_2Enum_2Enum > tyop_2Enum_2Enum > tyop_2Enum_2Enum ).

thf(c_2Ebool_2E_2F_5C,type,
    c_2Ebool_2E_2F_5C: $o > $o > $o ).

thf(c_2Enum_2E0,type,
    c_2Enum_2E0: tyop_2Enum_2Enum ).

thf(c_2Eprim__rec_2E_3C,type,
    c_2Eprim__rec_2E_3C: tyop_2Enum_2Enum > tyop_2Enum_2Enum > $o ).

thf(c_2Earithmetic_2E_3C_3D,type,
    c_2Earithmetic_2E_3C_3D: tyop_2Enum_2Enum > tyop_2Enum_2Enum > $o ).

thf(c_2Emin_2E_3D,type,
    c_2Emin_2E_3D: 
      !>[A_27a: $tType] : ( A_27a > A_27a > $o ) ).

thf(c_2Emin_2E_3D_3D_3E,type,
    c_2Emin_2E_3D_3D_3E: $o > $o > $o ).

thf(c_2Ebool_2E_3F,type,
    c_2Ebool_2E_3F: 
      !>[A_27a: $tType] : ( ( A_27a > $o ) > $o ) ).

thf(c_2Ebool_2E_3F_21,type,
    c_2Ebool_2E_3F_21: 
      !>[A_27a: $tType] : ( ( A_27a > $o ) > $o ) ).

thf(c_2Emin_2E_40,type,
    c_2Emin_2E_40: 
      !>[A_27a: $tType] : ( ( A_27a > $o ) > A_27a ) ).

thf(c_2Einteger_2EABS,type,
    c_2Einteger_2EABS: tyop_2Einteger_2Eint > tyop_2Einteger_2Eint ).

thf(c_2Earithmetic_2EBIT1,type,
    c_2Earithmetic_2EBIT1: tyop_2Enum_2Enum > tyop_2Enum_2Enum ).

thf(c_2Earithmetic_2EBIT2,type,
    c_2Earithmetic_2EBIT2: tyop_2Enum_2Enum > tyop_2Enum_2Enum ).

thf(c_2Ebool_2ECOND,type,
    c_2Ebool_2ECOND: 
      !>[A_27a: $tType] : ( $o > A_27a > A_27a > A_27a ) ).

thf(c_2Earithmetic_2EDIV,type,
    c_2Earithmetic_2EDIV: tyop_2Enum_2Enum > tyop_2Enum_2Enum > tyop_2Enum_2Enum ).

thf(c_2Ebool_2EF,type,
    c_2Ebool_2EF: $o ).

thf(c_2Epair_2EFST,type,
    c_2Epair_2EFST: 
      !>[A_27a: $tType,A_27b: $tType] : ( ( tyop_2Epair_2Eprod @ A_27a @ A_27b ) > A_27a ) ).

thf(c_2Earithmetic_2EMOD,type,
    c_2Earithmetic_2EMOD: tyop_2Enum_2Enum > tyop_2Enum_2Enum > tyop_2Enum_2Enum ).

thf(c_2Earithmetic_2ENUMERAL,type,
    c_2Earithmetic_2ENUMERAL: tyop_2Enum_2Enum > tyop_2Enum_2Enum ).

thf(c_2Einteger_2ENum,type,
    c_2Einteger_2ENum: tyop_2Einteger_2Eint > tyop_2Enum_2Enum ).

thf(c_2Equotient_2EQUOTIENT,type,
    c_2Equotient_2EQUOTIENT: 
      !>[A_27a: $tType,A_27b: $tType] : ( ( A_27a > A_27a > $o ) > ( A_27a > A_27b ) > ( A_27b > A_27a ) > $o ) ).

thf(c_2Epair_2ESND,type,
    c_2Epair_2ESND: 
      !>[A_27a: $tType,A_27b: $tType] : ( ( tyop_2Epair_2Eprod @ A_27a @ A_27b ) > A_27b ) ).

thf(c_2Enum_2ESUC,type,
    c_2Enum_2ESUC: tyop_2Enum_2Enum > tyop_2Enum_2Enum ).

thf(c_2Ebool_2ETYPE__DEFINITION,type,
    c_2Ebool_2ETYPE__DEFINITION: 
      !>[A_27a: $tType,A_27b: $tType] : ( ( A_27a > $o ) > ( A_27b > A_27a ) > $o ) ).

thf(c_2Earithmetic_2EZERO,type,
    c_2Earithmetic_2EZERO: tyop_2Enum_2Enum ).

thf(c_2Ebool_2E_5C_2F,type,
    c_2Ebool_2E_5C_2F: $o > $o > $o ).

thf(c_2Einteger_2Eint__0,type,
    c_2Einteger_2Eint__0: tyop_2Einteger_2Eint ).

thf(c_2Einteger_2Eint__1,type,
    c_2Einteger_2Eint__1: tyop_2Einteger_2Eint ).

thf(c_2Einteger_2Eint__ABS,type,
    c_2Einteger_2Eint__ABS: ( tyop_2Epair_2Eprod @ tyop_2Enum_2Enum @ tyop_2Enum_2Enum ) > tyop_2Einteger_2Eint ).

thf(c_2Einteger_2Eint__ABS__CLASS,type,
    c_2Einteger_2Eint__ABS__CLASS: ( ( tyop_2Epair_2Eprod @ tyop_2Enum_2Enum @ tyop_2Enum_2Enum ) > $o ) > tyop_2Einteger_2Eint ).

thf(c_2Einteger_2Eint__REP,type,
    c_2Einteger_2Eint__REP: tyop_2Einteger_2Eint > ( tyop_2Epair_2Eprod @ tyop_2Enum_2Enum @ tyop_2Enum_2Enum ) ).

thf(c_2Einteger_2Eint__REP__CLASS,type,
    c_2Einteger_2Eint__REP__CLASS: tyop_2Einteger_2Eint > ( tyop_2Epair_2Eprod @ tyop_2Enum_2Enum @ tyop_2Enum_2Enum ) > $o ).

thf(c_2Einteger_2Eint__add,type,
    c_2Einteger_2Eint__add: tyop_2Einteger_2Eint > tyop_2Einteger_2Eint > tyop_2Einteger_2Eint ).

thf(c_2Einteger_2Eint__div,type,
    c_2Einteger_2Eint__div: tyop_2Einteger_2Eint > tyop_2Einteger_2Eint > tyop_2Einteger_2Eint ).

thf(c_2Einteger_2Eint__divides,type,
    c_2Einteger_2Eint__divides: tyop_2Einteger_2Eint > tyop_2Einteger_2Eint > $o ).

thf(c_2Einteger_2Eint__ge,type,
    c_2Einteger_2Eint__ge: tyop_2Einteger_2Eint > tyop_2Einteger_2Eint > $o ).

thf(c_2Einteger_2Eint__gt,type,
    c_2Einteger_2Eint__gt: tyop_2Einteger_2Eint > tyop_2Einteger_2Eint > $o ).

thf(c_2Einteger_2Eint__le,type,
    c_2Einteger_2Eint__le: tyop_2Einteger_2Eint > tyop_2Einteger_2Eint > $o ).

thf(c_2Einteger_2Eint__lt,type,
    c_2Einteger_2Eint__lt: tyop_2Einteger_2Eint > tyop_2Einteger_2Eint > $o ).

thf(c_2Einteger_2Eint__mod,type,
    c_2Einteger_2Eint__mod: tyop_2Einteger_2Eint > tyop_2Einteger_2Eint > tyop_2Einteger_2Eint ).

thf(c_2Einteger_2Eint__mul,type,
    c_2Einteger_2Eint__mul: tyop_2Einteger_2Eint > tyop_2Einteger_2Eint > tyop_2Einteger_2Eint ).

thf(c_2Einteger_2Eint__neg,type,
    c_2Einteger_2Eint__neg: tyop_2Einteger_2Eint > tyop_2Einteger_2Eint ).

thf(c_2Einteger_2Eint__of__num,type,
    c_2Einteger_2Eint__of__num: tyop_2Enum_2Enum > tyop_2Einteger_2Eint ).

thf(c_2Einteger_2Eint__quot,type,
    c_2Einteger_2Eint__quot: tyop_2Einteger_2Eint > tyop_2Einteger_2Eint > tyop_2Einteger_2Eint ).

thf(c_2Einteger_2Eint__rem,type,
    c_2Einteger_2Eint__rem: tyop_2Einteger_2Eint > tyop_2Einteger_2Eint > tyop_2Einteger_2Eint ).

thf(c_2Einteger_2Eint__sub,type,
    c_2Einteger_2Eint__sub: tyop_2Einteger_2Eint > tyop_2Einteger_2Eint > tyop_2Einteger_2Eint ).

thf(c_2Einteger_2Etint__0,type,
    c_2Einteger_2Etint__0: tyop_2Epair_2Eprod @ tyop_2Enum_2Enum @ tyop_2Enum_2Enum ).

thf(c_2Einteger_2Etint__1,type,
    c_2Einteger_2Etint__1: tyop_2Epair_2Eprod @ tyop_2Enum_2Enum @ tyop_2Enum_2Enum ).

thf(c_2Einteger_2Etint__add,type,
    c_2Einteger_2Etint__add: ( tyop_2Epair_2Eprod @ tyop_2Enum_2Enum @ tyop_2Enum_2Enum ) > ( tyop_2Epair_2Eprod @ tyop_2Enum_2Enum @ tyop_2Enum_2Enum ) > ( tyop_2Epair_2Eprod @ tyop_2Enum_2Enum @ tyop_2Enum_2Enum ) ).

thf(c_2Einteger_2Etint__eq,type,
    c_2Einteger_2Etint__eq: ( tyop_2Epair_2Eprod @ tyop_2Enum_2Enum @ tyop_2Enum_2Enum ) > ( tyop_2Epair_2Eprod @ tyop_2Enum_2Enum @ tyop_2Enum_2Enum ) > $o ).

thf(c_2Einteger_2Etint__lt,type,
    c_2Einteger_2Etint__lt: ( tyop_2Epair_2Eprod @ tyop_2Enum_2Enum @ tyop_2Enum_2Enum ) > ( tyop_2Epair_2Eprod @ tyop_2Enum_2Enum @ tyop_2Enum_2Enum ) > $o ).

thf(c_2Einteger_2Etint__mul,type,
    c_2Einteger_2Etint__mul: ( tyop_2Epair_2Eprod @ tyop_2Enum_2Enum @ tyop_2Enum_2Enum ) > ( tyop_2Epair_2Eprod @ tyop_2Enum_2Enum @ tyop_2Enum_2Enum ) > ( tyop_2Epair_2Eprod @ tyop_2Enum_2Enum @ tyop_2Enum_2Enum ) ).

thf(c_2Einteger_2Etint__neg,type,
    c_2Einteger_2Etint__neg: ( tyop_2Epair_2Eprod @ tyop_2Enum_2Enum @ tyop_2Enum_2Enum ) > ( tyop_2Epair_2Eprod @ tyop_2Enum_2Enum @ tyop_2Enum_2Enum ) ).

thf(c_2Einteger_2Etint__of__num,type,
    c_2Einteger_2Etint__of__num: tyop_2Enum_2Enum > ( tyop_2Epair_2Eprod @ tyop_2Enum_2Enum @ tyop_2Enum_2Enum ) ).

thf(c_2Ebool_2E_7E,type,
    c_2Ebool_2E_7E: $o > $o ).

thf(logicdef_2E_2F_5C,axiom,
    ! [V0: $o,V1: $o] :
      ( ( c_2Ebool_2E_2F_5C @ V0 @ V1 )
    <=> ( V0
        & V1 ) ) ).

thf(logicdef_2E_5C_2F,axiom,
    ! [V0: $o,V1: $o] :
      ( ( c_2Ebool_2E_5C_2F @ V0 @ V1 )
    <=> ( V0
        | V1 ) ) ).

thf(logicdef_2E_7E,axiom,
    ! [V0: $o] :
      ( ( c_2Ebool_2E_7E @ V0 )
    <=> ( (~) @ V0 ) ) ).

thf(logicdef_2E_3D_3D_3E,axiom,
    ! [V0: $o,V1: $o] :
      ( ( c_2Emin_2E_3D_3D_3E @ V0 @ V1 )
    <=> ( V0
       => V1 ) ) ).

thf(logicdef_2E_3D,axiom,
    ! [A_27a: $tType,V0: A_27a,V1: A_27a] :
      ( ( c_2Emin_2E_3D @ A_27a @ V0 @ V1 )
    <=> ( V0 = V1 ) ) ).

thf(quantdef_2E_21,axiom,
    ! [A_27a: $tType,V0f: A_27a > $o] :
      ( ( c_2Ebool_2E_21 @ A_27a @ V0f )
    <=> ! [V1x: A_27a] : ( V0f @ V1x ) ) ).

thf(quantdef_2E_3F,axiom,
    ! [A_27a: $tType,V0f: A_27a > $o] :
      ( ( c_2Ebool_2E_3F @ A_27a @ V0f )
    <=> ? [V1x: A_27a] : ( V0f @ V1x ) ) ).

thf(thm_2Einteger_2Eint__ge,axiom,
    ! [V0x: tyop_2Einteger_2Eint,V1y: tyop_2Einteger_2Eint] :
      ( ( c_2Einteger_2Eint__ge @ V0x @ V1y )
      = ( c_2Einteger_2Eint__le @ V1y @ V0x ) ) ).

thf(thm_2Einteger_2Eint__gt,axiom,
    ! [V0x: tyop_2Einteger_2Eint,V1y: tyop_2Einteger_2Eint] :
      ( ( c_2Einteger_2Eint__gt @ V0x @ V1y )
      = ( c_2Einteger_2Eint__lt @ V1y @ V0x ) ) ).

thf(thm_2Einteger_2Eint__le,axiom,
    ! [V0x: tyop_2Einteger_2Eint,V1y: tyop_2Einteger_2Eint] :
      ( ( c_2Einteger_2Eint__le @ V0x @ V1y )
    <=> ( (~) @ ( c_2Einteger_2Eint__lt @ V1y @ V0x ) ) ) ).

thf(thm_2Einteger_2Eint__sub,axiom,
    ! [V0x: tyop_2Einteger_2Eint,V1y: tyop_2Einteger_2Eint] :
      ( ( c_2Einteger_2Eint__sub @ V0x @ V1y )
      = ( c_2Einteger_2Eint__add @ V0x @ ( c_2Einteger_2Eint__neg @ V1y ) ) ) ).

thf(thm_2Einteger_2Etint__0,axiom,
    ( c_2Einteger_2Etint__0
    = ( c_2Epair_2E_2C @ tyop_2Enum_2Enum @ tyop_2Enum_2Enum @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) ) ).

thf(thm_2Einteger_2Etint__1,axiom,
    ( c_2Einteger_2Etint__1
    = ( c_2Epair_2E_2C @ tyop_2Enum_2Enum @ tyop_2Enum_2Enum @ ( c_2Earithmetic_2E_2B @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) ) ).

thf(thm_2Einteger_2Etint__neg,axiom,
    ! [V0x: tyop_2Enum_2Enum,V1y: tyop_2Enum_2Enum] :
      ( ( c_2Einteger_2Etint__neg @ ( c_2Epair_2E_2C @ tyop_2Enum_2Enum @ tyop_2Enum_2Enum @ V0x @ V1y ) )
      = ( c_2Epair_2E_2C @ tyop_2Enum_2Enum @ tyop_2Enum_2Enum @ V1y @ V0x ) ) ).

thf(thm_2Einteger_2Etint__add,axiom,
    ! [V0x1: tyop_2Enum_2Enum,V1y1: tyop_2Enum_2Enum,V2x2: tyop_2Enum_2Enum,V3y2: tyop_2Enum_2Enum] :
      ( ( c_2Einteger_2Etint__add @ ( c_2Epair_2E_2C @ tyop_2Enum_2Enum @ tyop_2Enum_2Enum @ V0x1 @ V1y1 ) @ ( c_2Epair_2E_2C @ tyop_2Enum_2Enum @ tyop_2Enum_2Enum @ V2x2 @ V3y2 ) )
      = ( c_2Epair_2E_2C @ tyop_2Enum_2Enum @ tyop_2Enum_2Enum @ ( c_2Earithmetic_2E_2B @ V0x1 @ V2x2 ) @ ( c_2Earithmetic_2E_2B @ V1y1 @ V3y2 ) ) ) ).

thf(thm_2Einteger_2Etint__mul,axiom,
    ! [V0x1: tyop_2Enum_2Enum,V1y1: tyop_2Enum_2Enum,V2x2: tyop_2Enum_2Enum,V3y2: tyop_2Enum_2Enum] :
      ( ( c_2Einteger_2Etint__mul @ ( c_2Epair_2E_2C @ tyop_2Enum_2Enum @ tyop_2Enum_2Enum @ V0x1 @ V1y1 ) @ ( c_2Epair_2E_2C @ tyop_2Enum_2Enum @ tyop_2Enum_2Enum @ V2x2 @ V3y2 ) )
      = ( c_2Epair_2E_2C @ tyop_2Enum_2Enum @ tyop_2Enum_2Enum @ ( c_2Earithmetic_2E_2B @ ( c_2Earithmetic_2E_2A @ V0x1 @ V2x2 ) @ ( c_2Earithmetic_2E_2A @ V1y1 @ V3y2 ) ) @ ( c_2Earithmetic_2E_2B @ ( c_2Earithmetic_2E_2A @ V0x1 @ V3y2 ) @ ( c_2Earithmetic_2E_2A @ V1y1 @ V2x2 ) ) ) ) ).

thf(thm_2Einteger_2Etint__lt,axiom,
    ! [V0x1: tyop_2Enum_2Enum,V1y1: tyop_2Enum_2Enum,V2x2: tyop_2Enum_2Enum,V3y2: tyop_2Enum_2Enum] :
      ( ( c_2Einteger_2Etint__lt @ ( c_2Epair_2E_2C @ tyop_2Enum_2Enum @ tyop_2Enum_2Enum @ V0x1 @ V1y1 ) @ ( c_2Epair_2E_2C @ tyop_2Enum_2Enum @ tyop_2Enum_2Enum @ V2x2 @ V3y2 ) )
      = ( c_2Eprim__rec_2E_3C @ ( c_2Earithmetic_2E_2B @ V0x1 @ V3y2 ) @ ( c_2Earithmetic_2E_2B @ V2x2 @ V1y1 ) ) ) ).

thf(thm_2Einteger_2Etint__eq,axiom,
    ! [V0x1: tyop_2Enum_2Enum,V1y1: tyop_2Enum_2Enum,V2x2: tyop_2Enum_2Enum,V3y2: tyop_2Enum_2Enum] :
      ( ( c_2Einteger_2Etint__eq @ ( c_2Epair_2E_2C @ tyop_2Enum_2Enum @ tyop_2Enum_2Enum @ V0x1 @ V1y1 ) @ ( c_2Epair_2E_2C @ tyop_2Enum_2Enum @ tyop_2Enum_2Enum @ V2x2 @ V3y2 ) )
    <=> ( ( c_2Earithmetic_2E_2B @ V0x1 @ V3y2 )
        = ( c_2Earithmetic_2E_2B @ V2x2 @ V1y1 ) ) ) ).

thf(thm_2Einteger_2Etint__of__num,axiom,
    ( ( ( c_2Einteger_2Etint__of__num @ c_2Enum_2E0 )
      = c_2Einteger_2Etint__0 )
    & ! [V0n: tyop_2Enum_2Enum] :
        ( ( c_2Einteger_2Etint__of__num @ ( c_2Enum_2ESUC @ V0n ) )
        = ( c_2Einteger_2Etint__add @ ( c_2Einteger_2Etint__of__num @ V0n ) @ c_2Einteger_2Etint__1 ) ) ) ).

thf(thm_2Einteger_2Eint__TY__DEF,axiom,
    ? [V0rep: tyop_2Einteger_2Eint > ( tyop_2Epair_2Eprod @ tyop_2Enum_2Enum @ tyop_2Enum_2Enum ) > $o] :
      ( c_2Ebool_2ETYPE__DEFINITION @ ( ( tyop_2Epair_2Eprod @ tyop_2Enum_2Enum @ tyop_2Enum_2Enum ) > $o ) @ tyop_2Einteger_2Eint
      @ ^ [V1c: ( tyop_2Epair_2Eprod @ tyop_2Enum_2Enum @ tyop_2Enum_2Enum ) > $o] :
          ( c_2Ebool_2E_3F @ ( tyop_2Epair_2Eprod @ tyop_2Enum_2Enum @ tyop_2Enum_2Enum )
          @ ^ [V2r: tyop_2Epair_2Eprod @ tyop_2Enum_2Enum @ tyop_2Enum_2Enum] : ( c_2Ebool_2E_2F_5C @ ( c_2Einteger_2Etint__eq @ V2r @ V2r ) @ ( c_2Emin_2E_3D @ ( ( tyop_2Epair_2Eprod @ tyop_2Enum_2Enum @ tyop_2Enum_2Enum ) > $o ) @ V1c @ ( c_2Einteger_2Etint__eq @ V2r ) ) ) )
      @ V0rep ) ).

thf(thm_2Einteger_2Eint__bijections,axiom,
    ( ! [V0a: tyop_2Einteger_2Eint] :
        ( ( c_2Einteger_2Eint__ABS__CLASS @ ( c_2Einteger_2Eint__REP__CLASS @ V0a ) )
        = V0a )
    & ! [V1r: ( tyop_2Epair_2Eprod @ tyop_2Enum_2Enum @ tyop_2Enum_2Enum ) > $o] :
        ( ( ^ [V2c: ( tyop_2Epair_2Eprod @ tyop_2Enum_2Enum @ tyop_2Enum_2Enum ) > $o] :
              ( c_2Ebool_2E_3F @ ( tyop_2Epair_2Eprod @ tyop_2Enum_2Enum @ tyop_2Enum_2Enum )
              @ ^ [V3r: tyop_2Epair_2Eprod @ tyop_2Enum_2Enum @ tyop_2Enum_2Enum] : ( c_2Ebool_2E_2F_5C @ ( c_2Einteger_2Etint__eq @ V3r @ V3r ) @ ( c_2Emin_2E_3D @ ( ( tyop_2Epair_2Eprod @ tyop_2Enum_2Enum @ tyop_2Enum_2Enum ) > $o ) @ V2c @ ( c_2Einteger_2Etint__eq @ V3r ) ) ) )
          @ V1r )
      <=> ( ( c_2Einteger_2Eint__REP__CLASS @ ( c_2Einteger_2Eint__ABS__CLASS @ V1r ) )
          = V1r ) ) ) ).

thf(thm_2Einteger_2Eint__REP__def,axiom,
    ! [V0a: tyop_2Einteger_2Eint] :
      ( ( c_2Einteger_2Eint__REP @ V0a )
      = ( c_2Emin_2E_40 @ ( tyop_2Epair_2Eprod @ tyop_2Enum_2Enum @ tyop_2Enum_2Enum ) @ ( c_2Einteger_2Eint__REP__CLASS @ V0a ) ) ) ).

thf(thm_2Einteger_2Eint__ABS__def,axiom,
    ! [V0r: tyop_2Epair_2Eprod @ tyop_2Enum_2Enum @ tyop_2Enum_2Enum] :
      ( ( c_2Einteger_2Eint__ABS @ V0r )
      = ( c_2Einteger_2Eint__ABS__CLASS @ ( c_2Einteger_2Etint__eq @ V0r ) ) ) ).

thf(thm_2Einteger_2Eint__0,axiom,
    ( c_2Einteger_2Eint__0
    = ( c_2Einteger_2Eint__ABS @ c_2Einteger_2Etint__0 ) ) ).

thf(thm_2Einteger_2Eint__1,axiom,
    ( c_2Einteger_2Eint__1
    = ( c_2Einteger_2Eint__ABS @ c_2Einteger_2Etint__1 ) ) ).

thf(thm_2Einteger_2Eint__neg,axiom,
    ! [V0T1: tyop_2Einteger_2Eint] :
      ( ( c_2Einteger_2Eint__neg @ V0T1 )
      = ( c_2Einteger_2Eint__ABS @ ( c_2Einteger_2Etint__neg @ ( c_2Einteger_2Eint__REP @ V0T1 ) ) ) ) ).

thf(thm_2Einteger_2Eint__add,axiom,
    ! [V0T1: tyop_2Einteger_2Eint,V1T2: tyop_2Einteger_2Eint] :
      ( ( c_2Einteger_2Eint__add @ V0T1 @ V1T2 )
      = ( c_2Einteger_2Eint__ABS @ ( c_2Einteger_2Etint__add @ ( c_2Einteger_2Eint__REP @ V0T1 ) @ ( c_2Einteger_2Eint__REP @ V1T2 ) ) ) ) ).

thf(thm_2Einteger_2Eint__mul,axiom,
    ! [V0T1: tyop_2Einteger_2Eint,V1T2: tyop_2Einteger_2Eint] :
      ( ( c_2Einteger_2Eint__mul @ V0T1 @ V1T2 )
      = ( c_2Einteger_2Eint__ABS @ ( c_2Einteger_2Etint__mul @ ( c_2Einteger_2Eint__REP @ V0T1 ) @ ( c_2Einteger_2Eint__REP @ V1T2 ) ) ) ) ).

thf(thm_2Einteger_2Eint__lt,axiom,
    ! [V0T1: tyop_2Einteger_2Eint,V1T2: tyop_2Einteger_2Eint] :
      ( ( c_2Einteger_2Eint__lt @ V0T1 @ V1T2 )
      = ( c_2Einteger_2Etint__lt @ ( c_2Einteger_2Eint__REP @ V0T1 ) @ ( c_2Einteger_2Eint__REP @ V1T2 ) ) ) ).

thf(thm_2Einteger_2ENum,axiom,
    ! [V0i: tyop_2Einteger_2Eint] :
      ( ( c_2Einteger_2ENum @ V0i )
      = ( c_2Emin_2E_40 @ tyop_2Enum_2Enum
        @ ^ [V1n: tyop_2Enum_2Enum] : ( c_2Emin_2E_3D @ tyop_2Einteger_2Eint @ V0i @ ( c_2Einteger_2Eint__of__num @ V1n ) ) ) ) ).

thf(thm_2Einteger_2Eint__div,axiom,
    ! [V0i: tyop_2Einteger_2Eint,V1j: tyop_2Einteger_2Eint] :
      ( ( (~)
        @ ( V1j
          = ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) ) )
     => ( ( c_2Einteger_2Eint__div @ V0i @ V1j )
        = ( c_2Ebool_2ECOND @ tyop_2Einteger_2Eint @ ( c_2Einteger_2Eint__lt @ ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) @ V1j ) @ ( c_2Ebool_2ECOND @ tyop_2Einteger_2Eint @ ( c_2Einteger_2Eint__le @ ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) @ V0i ) @ ( c_2Einteger_2Eint__of__num @ ( c_2Earithmetic_2EDIV @ ( c_2Einteger_2ENum @ V0i ) @ ( c_2Einteger_2ENum @ V1j ) ) ) @ ( c_2Einteger_2Eint__add @ ( c_2Einteger_2Eint__neg @ ( c_2Einteger_2Eint__of__num @ ( c_2Earithmetic_2EDIV @ ( c_2Einteger_2ENum @ ( c_2Einteger_2Eint__neg @ V0i ) ) @ ( c_2Einteger_2ENum @ V1j ) ) ) ) @ ( c_2Ebool_2ECOND @ tyop_2Einteger_2Eint @ ( c_2Emin_2E_3D @ tyop_2Enum_2Enum @ ( c_2Earithmetic_2EMOD @ ( c_2Einteger_2ENum @ ( c_2Einteger_2Eint__neg @ V0i ) ) @ ( c_2Einteger_2ENum @ V1j ) ) @ c_2Enum_2E0 ) @ ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) @ ( c_2Einteger_2Eint__neg @ ( c_2Einteger_2Eint__of__num @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) ) ) ) ) @ ( c_2Ebool_2ECOND @ tyop_2Einteger_2Eint @ ( c_2Einteger_2Eint__le @ ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) @ V0i ) @ ( c_2Einteger_2Eint__add @ ( c_2Einteger_2Eint__neg @ ( c_2Einteger_2Eint__of__num @ ( c_2Earithmetic_2EDIV @ ( c_2Einteger_2ENum @ V0i ) @ ( c_2Einteger_2ENum @ ( c_2Einteger_2Eint__neg @ V1j ) ) ) ) ) @ ( c_2Ebool_2ECOND @ tyop_2Einteger_2Eint @ ( c_2Emin_2E_3D @ tyop_2Enum_2Enum @ ( c_2Earithmetic_2EMOD @ ( c_2Einteger_2ENum @ V0i ) @ ( c_2Einteger_2ENum @ ( c_2Einteger_2Eint__neg @ V1j ) ) ) @ c_2Enum_2E0 ) @ ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) @ ( c_2Einteger_2Eint__neg @ ( c_2Einteger_2Eint__of__num @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) ) ) ) @ ( c_2Einteger_2Eint__of__num @ ( c_2Earithmetic_2EDIV @ ( c_2Einteger_2ENum @ ( c_2Einteger_2Eint__neg @ V0i ) ) @ ( c_2Einteger_2ENum @ ( c_2Einteger_2Eint__neg @ V1j ) ) ) ) ) ) ) ) ).

thf(thm_2Einteger_2Eint__mod,axiom,
    ! [V0i: tyop_2Einteger_2Eint,V1j: tyop_2Einteger_2Eint] :
      ( ( (~)
        @ ( V1j
          = ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) ) )
     => ( ( c_2Einteger_2Eint__mod @ V0i @ V1j )
        = ( c_2Einteger_2Eint__sub @ V0i @ ( c_2Einteger_2Eint__mul @ ( c_2Einteger_2Eint__div @ V0i @ V1j ) @ V1j ) ) ) ) ).

thf(thm_2Einteger_2EINT__ABS,axiom,
    ! [V0n: tyop_2Einteger_2Eint] :
      ( ( c_2Einteger_2EABS @ V0n )
      = ( c_2Ebool_2ECOND @ tyop_2Einteger_2Eint @ ( c_2Einteger_2Eint__lt @ V0n @ ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) ) @ ( c_2Einteger_2Eint__neg @ V0n ) @ V0n ) ) ).

thf(thm_2Einteger_2Eint__quot,axiom,
    ! [V0i: tyop_2Einteger_2Eint,V1j: tyop_2Einteger_2Eint] :
      ( ( (~)
        @ ( V1j
          = ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) ) )
     => ( ( c_2Einteger_2Eint__quot @ V0i @ V1j )
        = ( c_2Ebool_2ECOND @ tyop_2Einteger_2Eint @ ( c_2Einteger_2Eint__lt @ ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) @ V1j ) @ ( c_2Ebool_2ECOND @ tyop_2Einteger_2Eint @ ( c_2Einteger_2Eint__le @ ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) @ V0i ) @ ( c_2Einteger_2Eint__of__num @ ( c_2Earithmetic_2EDIV @ ( c_2Einteger_2ENum @ V0i ) @ ( c_2Einteger_2ENum @ V1j ) ) ) @ ( c_2Einteger_2Eint__neg @ ( c_2Einteger_2Eint__of__num @ ( c_2Earithmetic_2EDIV @ ( c_2Einteger_2ENum @ ( c_2Einteger_2Eint__neg @ V0i ) ) @ ( c_2Einteger_2ENum @ V1j ) ) ) ) ) @ ( c_2Ebool_2ECOND @ tyop_2Einteger_2Eint @ ( c_2Einteger_2Eint__le @ ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) @ V0i ) @ ( c_2Einteger_2Eint__neg @ ( c_2Einteger_2Eint__of__num @ ( c_2Earithmetic_2EDIV @ ( c_2Einteger_2ENum @ V0i ) @ ( c_2Einteger_2ENum @ ( c_2Einteger_2Eint__neg @ V1j ) ) ) ) ) @ ( c_2Einteger_2Eint__of__num @ ( c_2Earithmetic_2EDIV @ ( c_2Einteger_2ENum @ ( c_2Einteger_2Eint__neg @ V0i ) ) @ ( c_2Einteger_2ENum @ ( c_2Einteger_2Eint__neg @ V1j ) ) ) ) ) ) ) ) ).

thf(thm_2Einteger_2Eint__rem,axiom,
    ! [V0i: tyop_2Einteger_2Eint,V1j: tyop_2Einteger_2Eint] :
      ( ( (~)
        @ ( V1j
          = ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) ) )
     => ( ( c_2Einteger_2Eint__rem @ V0i @ V1j )
        = ( c_2Einteger_2Eint__sub @ V0i @ ( c_2Einteger_2Eint__mul @ ( c_2Einteger_2Eint__quot @ V0i @ V1j ) @ V1j ) ) ) ) ).

thf(thm_2Einteger_2EINT__DIVIDES,axiom,
    ! [V0p: tyop_2Einteger_2Eint,V1q: tyop_2Einteger_2Eint] :
      ( ( c_2Einteger_2Eint__divides @ V0p @ V1q )
    <=> ? [V2m: tyop_2Einteger_2Eint] :
          ( ( c_2Einteger_2Eint__mul @ V2m @ V0p )
          = V1q ) ) ).

thf(thm_2Einteger_2EINT__LT,axiom,
    ! [V0m: tyop_2Enum_2Enum,V1n: tyop_2Enum_2Enum] :
      ( ( c_2Einteger_2Eint__lt @ ( c_2Einteger_2Eint__of__num @ V0m ) @ ( c_2Einteger_2Eint__of__num @ V1n ) )
      = ( c_2Eprim__rec_2E_3C @ V0m @ V1n ) ) ).

thf(thm_2Einteger_2EINT__LE,axiom,
    ! [V0m: tyop_2Enum_2Enum,V1n: tyop_2Enum_2Enum] :
      ( ( c_2Einteger_2Eint__le @ ( c_2Einteger_2Eint__of__num @ V0m ) @ ( c_2Einteger_2Eint__of__num @ V1n ) )
      = ( c_2Earithmetic_2E_3C_3D @ V0m @ V1n ) ) ).

thf(thm_2Einteger_2EINT__POS,axiom,
    ! [V0n: tyop_2Enum_2Enum] : ( c_2Einteger_2Eint__le @ ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) @ ( c_2Einteger_2Eint__of__num @ V0n ) ) ).

thf(thm_2Einteger_2EINT,axiom,
    ! [V0n: tyop_2Enum_2Enum] :
      ( ( c_2Einteger_2Eint__of__num @ ( c_2Enum_2ESUC @ V0n ) )
      = ( c_2Einteger_2Eint__add @ ( c_2Einteger_2Eint__of__num @ V0n ) @ ( c_2Einteger_2Eint__of__num @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) ) ) ).

thf(thm_2Einteger_2EINT__EQ__RMUL,axiom,
    ! [V0x: tyop_2Einteger_2Eint,V1y: tyop_2Einteger_2Eint,V2z: tyop_2Einteger_2Eint] :
      ( ( ( c_2Einteger_2Eint__mul @ V0x @ V2z )
        = ( c_2Einteger_2Eint__mul @ V1y @ V2z ) )
    <=> ( ( V2z
          = ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) )
        | ( V0x = V1y ) ) ) ).

thf(thm_2Einteger_2EINT__EQ__LMUL,axiom,
    ! [V0x: tyop_2Einteger_2Eint,V1y: tyop_2Einteger_2Eint,V2z: tyop_2Einteger_2Eint] :
      ( ( ( c_2Einteger_2Eint__mul @ V0x @ V1y )
        = ( c_2Einteger_2Eint__mul @ V0x @ V2z ) )
    <=> ( ( V0x
          = ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) )
        | ( V1y = V2z ) ) ) ).

thf(thm_2Einteger_2EINT__ENTIRE,axiom,
    ! [V0x: tyop_2Einteger_2Eint,V1y: tyop_2Einteger_2Eint] :
      ( ( ( c_2Einteger_2Eint__mul @ V0x @ V1y )
        = ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) )
    <=> ( ( V0x
          = ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) )
        | ( V1y
          = ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) ) ) ) ).

thf(thm_2Einteger_2EINT__LT__ADDL,axiom,
    ! [V0x: tyop_2Einteger_2Eint,V1y: tyop_2Einteger_2Eint] :
      ( ( c_2Einteger_2Eint__lt @ V1y @ ( c_2Einteger_2Eint__add @ V0x @ V1y ) )
      = ( c_2Einteger_2Eint__lt @ ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) @ V0x ) ) ).

thf(thm_2Einteger_2EINT__LT__ADDR,axiom,
    ! [V0x: tyop_2Einteger_2Eint,V1y: tyop_2Einteger_2Eint] :
      ( ( c_2Einteger_2Eint__lt @ V0x @ ( c_2Einteger_2Eint__add @ V0x @ V1y ) )
      = ( c_2Einteger_2Eint__lt @ ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) @ V1y ) ) ).

thf(thm_2Einteger_2EINT__LE__ADDL,axiom,
    ! [V0x: tyop_2Einteger_2Eint,V1y: tyop_2Einteger_2Eint] :
      ( ( c_2Einteger_2Eint__le @ V1y @ ( c_2Einteger_2Eint__add @ V0x @ V1y ) )
      = ( c_2Einteger_2Eint__le @ ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) @ V0x ) ) ).

thf(thm_2Einteger_2EINT__LE__ADDR,axiom,
    ! [V0x: tyop_2Einteger_2Eint,V1y: tyop_2Einteger_2Eint] :
      ( ( c_2Einteger_2Eint__le @ V0x @ ( c_2Einteger_2Eint__add @ V0x @ V1y ) )
      = ( c_2Einteger_2Eint__le @ ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) @ V1y ) ) ).

thf(thm_2Einteger_2EINT__LT__IMP__NE,axiom,
    ! [V0x: tyop_2Einteger_2Eint,V1y: tyop_2Einteger_2Eint] :
      ( ( c_2Einteger_2Eint__lt @ V0x @ V1y )
     => ( (~) @ ( V0x = V1y ) ) ) ).

thf(thm_2Einteger_2EINT__NEG__MINUS1,axiom,
    ! [V0x: tyop_2Einteger_2Eint] :
      ( ( c_2Einteger_2Eint__neg @ V0x )
      = ( c_2Einteger_2Eint__mul @ ( c_2Einteger_2Eint__neg @ ( c_2Einteger_2Eint__of__num @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) ) @ V0x ) ) ).

thf(thm_2Einteger_2EINT__NEG__EQ,axiom,
    ! [V0x: tyop_2Einteger_2Eint,V1y: tyop_2Einteger_2Eint] :
      ( ( ( c_2Einteger_2Eint__neg @ V0x )
        = V1y )
    <=> ( V0x
        = ( c_2Einteger_2Eint__neg @ V1y ) ) ) ).

thf(thm_2Einteger_2EINT__SUB__RDISTRIB,axiom,
    ! [V0x: tyop_2Einteger_2Eint,V1y: tyop_2Einteger_2Eint,V2z: tyop_2Einteger_2Eint] :
      ( ( c_2Einteger_2Eint__mul @ ( c_2Einteger_2Eint__sub @ V0x @ V1y ) @ V2z )
      = ( c_2Einteger_2Eint__sub @ ( c_2Einteger_2Eint__mul @ V0x @ V2z ) @ ( c_2Einteger_2Eint__mul @ V1y @ V2z ) ) ) ).

thf(thm_2Einteger_2EINT__SUB__LDISTRIB,axiom,
    ! [V0x: tyop_2Einteger_2Eint,V1y: tyop_2Einteger_2Eint,V2z: tyop_2Einteger_2Eint] :
      ( ( c_2Einteger_2Eint__mul @ V0x @ ( c_2Einteger_2Eint__sub @ V1y @ V2z ) )
      = ( c_2Einteger_2Eint__sub @ ( c_2Einteger_2Eint__mul @ V0x @ V1y ) @ ( c_2Einteger_2Eint__mul @ V0x @ V2z ) ) ) ).

thf(thm_2Einteger_2EINT__ADD__SUB,axiom,
    ! [V0x: tyop_2Einteger_2Eint,V1y: tyop_2Einteger_2Eint] :
      ( ( c_2Einteger_2Eint__sub @ ( c_2Einteger_2Eint__add @ V0x @ V1y ) @ V0x )
      = V1y ) ).

thf(thm_2Einteger_2EINT__SUB__LE,axiom,
    ! [V0x: tyop_2Einteger_2Eint,V1y: tyop_2Einteger_2Eint] :
      ( ( c_2Einteger_2Eint__le @ ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) @ ( c_2Einteger_2Eint__sub @ V0x @ V1y ) )
      = ( c_2Einteger_2Eint__le @ V1y @ V0x ) ) ).

thf(thm_2Einteger_2EINT__SUB__LT,axiom,
    ! [V0x: tyop_2Einteger_2Eint,V1y: tyop_2Einteger_2Eint] :
      ( ( c_2Einteger_2Eint__lt @ ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) @ ( c_2Einteger_2Eint__sub @ V0x @ V1y ) )
      = ( c_2Einteger_2Eint__lt @ V1y @ V0x ) ) ).

thf(thm_2Einteger_2EINT__NEG__SUB,axiom,
    ! [V0x: tyop_2Einteger_2Eint,V1y: tyop_2Einteger_2Eint] :
      ( ( c_2Einteger_2Eint__neg @ ( c_2Einteger_2Eint__sub @ V0x @ V1y ) )
      = ( c_2Einteger_2Eint__sub @ V1y @ V0x ) ) ).

thf(thm_2Einteger_2EINT__NEG__0,axiom,
    ( ( c_2Einteger_2Eint__neg @ ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) )
    = ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) ) ).

thf(thm_2Einteger_2EINT__NEG__EQ0,axiom,
    ! [V0x: tyop_2Einteger_2Eint] :
      ( ( ( c_2Einteger_2Eint__neg @ V0x )
        = ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) )
    <=> ( V0x
        = ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) ) ) ).

thf(thm_2Einteger_2EINT__LE__NEGR,axiom,
    ! [V0x: tyop_2Einteger_2Eint] :
      ( ( c_2Einteger_2Eint__le @ V0x @ ( c_2Einteger_2Eint__neg @ V0x ) )
      = ( c_2Einteger_2Eint__le @ V0x @ ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) ) ) ).

thf(thm_2Einteger_2EINT__LE__NEGL,axiom,
    ! [V0x: tyop_2Einteger_2Eint] :
      ( ( c_2Einteger_2Eint__le @ ( c_2Einteger_2Eint__neg @ V0x ) @ V0x )
      = ( c_2Einteger_2Eint__le @ ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) @ V0x ) ) ).

thf(thm_2Einteger_2EINT__LE__DOUBLE,axiom,
    ! [V0x: tyop_2Einteger_2Eint] :
      ( ( c_2Einteger_2Eint__le @ ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) @ ( c_2Einteger_2Eint__add @ V0x @ V0x ) )
      = ( c_2Einteger_2Eint__le @ ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) @ V0x ) ) ).

thf(thm_2Einteger_2EINT__SUB__0,axiom,
    ! [V0x: tyop_2Einteger_2Eint,V1y: tyop_2Einteger_2Eint] :
      ( ( ( c_2Einteger_2Eint__sub @ V0x @ V1y )
        = ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) )
    <=> ( V0x = V1y ) ) ).

thf(thm_2Einteger_2EINT__SUB__REFL,axiom,
    ! [V0x: tyop_2Einteger_2Eint] :
      ( ( c_2Einteger_2Eint__sub @ V0x @ V0x )
      = ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) ) ).

thf(thm_2Einteger_2EINT__SUB__ADD2,axiom,
    ! [V0x: tyop_2Einteger_2Eint,V1y: tyop_2Einteger_2Eint] :
      ( ( c_2Einteger_2Eint__add @ V1y @ ( c_2Einteger_2Eint__sub @ V0x @ V1y ) )
      = V0x ) ).

thf(thm_2Einteger_2EINT__SUB__ADD,axiom,
    ! [V0x: tyop_2Einteger_2Eint,V1y: tyop_2Einteger_2Eint] :
      ( ( c_2Einteger_2Eint__add @ ( c_2Einteger_2Eint__sub @ V0x @ V1y ) @ V1y )
      = V0x ) ).

thf(thm_2Einteger_2EINT__LT__ADD1,axiom,
    ! [V0x: tyop_2Einteger_2Eint,V1y: tyop_2Einteger_2Eint] :
      ( ( c_2Einteger_2Eint__le @ V0x @ V1y )
     => ( c_2Einteger_2Eint__lt @ V0x @ ( c_2Einteger_2Eint__add @ V1y @ ( c_2Einteger_2Eint__of__num @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) ) ) ) ).

thf(thm_2Einteger_2EINT__LT__ADDNEG2,axiom,
    ! [V0x: tyop_2Einteger_2Eint,V1y: tyop_2Einteger_2Eint,V2z: tyop_2Einteger_2Eint] :
      ( ( c_2Einteger_2Eint__lt @ ( c_2Einteger_2Eint__add @ V0x @ ( c_2Einteger_2Eint__neg @ V1y ) ) @ V2z )
      = ( c_2Einteger_2Eint__lt @ V0x @ ( c_2Einteger_2Eint__add @ V2z @ V1y ) ) ) ).

thf(thm_2Einteger_2EINT__LT__ADDNEG,axiom,
    ! [V0x: tyop_2Einteger_2Eint,V1y: tyop_2Einteger_2Eint,V2z: tyop_2Einteger_2Eint] :
      ( ( c_2Einteger_2Eint__lt @ V1y @ ( c_2Einteger_2Eint__add @ V0x @ ( c_2Einteger_2Eint__neg @ V2z ) ) )
      = ( c_2Einteger_2Eint__lt @ ( c_2Einteger_2Eint__add @ V1y @ V2z ) @ V0x ) ) ).

thf(thm_2Einteger_2EINT__LT__ADD,axiom,
    ! [V0x: tyop_2Einteger_2Eint,V1y: tyop_2Einteger_2Eint] :
      ( ( ( c_2Einteger_2Eint__lt @ ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) @ V0x )
        & ( c_2Einteger_2Eint__lt @ ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) @ V1y ) )
     => ( c_2Einteger_2Eint__lt @ ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) @ ( c_2Einteger_2Eint__add @ V0x @ V1y ) ) ) ).

thf(thm_2Einteger_2EINT__LE__ADD,axiom,
    ! [V0x: tyop_2Einteger_2Eint,V1y: tyop_2Einteger_2Eint] :
      ( ( ( c_2Einteger_2Eint__le @ ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) @ V0x )
        & ( c_2Einteger_2Eint__le @ ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) @ V1y ) )
     => ( c_2Einteger_2Eint__le @ ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) @ ( c_2Einteger_2Eint__add @ V0x @ V1y ) ) ) ).

thf(thm_2Einteger_2EINT__LE__ADD2,axiom,
    ! [V0w: tyop_2Einteger_2Eint,V1x: tyop_2Einteger_2Eint,V2y: tyop_2Einteger_2Eint,V3z: tyop_2Einteger_2Eint] :
      ( ( ( c_2Einteger_2Eint__le @ V0w @ V1x )
        & ( c_2Einteger_2Eint__le @ V2y @ V3z ) )
     => ( c_2Einteger_2Eint__le @ ( c_2Einteger_2Eint__add @ V0w @ V2y ) @ ( c_2Einteger_2Eint__add @ V1x @ V3z ) ) ) ).

thf(thm_2Einteger_2EINT__LT__ADD2,axiom,
    ! [V0w: tyop_2Einteger_2Eint,V1x: tyop_2Einteger_2Eint,V2y: tyop_2Einteger_2Eint,V3z: tyop_2Einteger_2Eint] :
      ( ( ( c_2Einteger_2Eint__lt @ V0w @ V1x )
        & ( c_2Einteger_2Eint__lt @ V2y @ V3z ) )
     => ( c_2Einteger_2Eint__lt @ ( c_2Einteger_2Eint__add @ V0w @ V2y ) @ ( c_2Einteger_2Eint__add @ V1x @ V3z ) ) ) ).

thf(thm_2Einteger_2EINT__LE__RADD,axiom,
    ! [V0x: tyop_2Einteger_2Eint,V1y: tyop_2Einteger_2Eint,V2z: tyop_2Einteger_2Eint] :
      ( ( c_2Einteger_2Eint__le @ ( c_2Einteger_2Eint__add @ V0x @ V2z ) @ ( c_2Einteger_2Eint__add @ V1y @ V2z ) )
      = ( c_2Einteger_2Eint__le @ V0x @ V1y ) ) ).

thf(thm_2Einteger_2EINT__LE__LADD,axiom,
    ! [V0x: tyop_2Einteger_2Eint,V1y: tyop_2Einteger_2Eint,V2z: tyop_2Einteger_2Eint] :
      ( ( c_2Einteger_2Eint__le @ ( c_2Einteger_2Eint__add @ V0x @ V1y ) @ ( c_2Einteger_2Eint__add @ V0x @ V2z ) )
      = ( c_2Einteger_2Eint__le @ V1y @ V2z ) ) ).

thf(thm_2Einteger_2EINT__LT__01,axiom,
    c_2Einteger_2Eint__lt @ ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) @ ( c_2Einteger_2Eint__of__num @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) ).

thf(thm_2Einteger_2EINT__LE__01,axiom,
    c_2Einteger_2Eint__le @ ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) @ ( c_2Einteger_2Eint__of__num @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) ).

thf(thm_2Einteger_2EINT__LE__SQUARE,axiom,
    ! [V0x: tyop_2Einteger_2Eint] : ( c_2Einteger_2Eint__le @ ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) @ ( c_2Einteger_2Eint__mul @ V0x @ V0x ) ) ).

thf(thm_2Einteger_2EINT__LE__MUL,axiom,
    ! [V0x: tyop_2Einteger_2Eint,V1y: tyop_2Einteger_2Eint] :
      ( ( ( c_2Einteger_2Eint__le @ ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) @ V0x )
        & ( c_2Einteger_2Eint__le @ ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) @ V1y ) )
     => ( c_2Einteger_2Eint__le @ ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) @ ( c_2Einteger_2Eint__mul @ V0x @ V1y ) ) ) ).

thf(thm_2Einteger_2EINT__LE__NEGTOTAL,axiom,
    ! [V0x: tyop_2Einteger_2Eint] :
      ( ( c_2Einteger_2Eint__le @ ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) @ V0x )
      | ( c_2Einteger_2Eint__le @ ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) @ ( c_2Einteger_2Eint__neg @ V0x ) ) ) ).

thf(thm_2Einteger_2EINT__LT__NEGTOTAL,axiom,
    ! [V0x: tyop_2Einteger_2Eint] :
      ( ( V0x
        = ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) )
      | ( c_2Einteger_2Eint__lt @ ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) @ V0x )
      | ( c_2Einteger_2Eint__lt @ ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) @ ( c_2Einteger_2Eint__neg @ V0x ) ) ) ).

thf(thm_2Einteger_2EINT__NEG__GE0,axiom,
    ! [V0x: tyop_2Einteger_2Eint] :
      ( ( c_2Einteger_2Eint__le @ ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) @ ( c_2Einteger_2Eint__neg @ V0x ) )
      = ( c_2Einteger_2Eint__le @ V0x @ ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) ) ) ).

thf(thm_2Einteger_2EINT__NEG__LE0,axiom,
    ! [V0x: tyop_2Einteger_2Eint] :
      ( ( c_2Einteger_2Eint__le @ ( c_2Einteger_2Eint__neg @ V0x ) @ ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) )
      = ( c_2Einteger_2Eint__le @ ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) @ V0x ) ) ).

thf(thm_2Einteger_2EINT__NEG__GT0,axiom,
    ! [V0x: tyop_2Einteger_2Eint] :
      ( ( c_2Einteger_2Eint__lt @ ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) @ ( c_2Einteger_2Eint__neg @ V0x ) )
      = ( c_2Einteger_2Eint__lt @ V0x @ ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) ) ) ).

thf(thm_2Einteger_2EINT__NEG__LT0,axiom,
    ! [V0x: tyop_2Einteger_2Eint] :
      ( ( c_2Einteger_2Eint__lt @ ( c_2Einteger_2Eint__neg @ V0x ) @ ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) )
      = ( c_2Einteger_2Eint__lt @ ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) @ V0x ) ) ).

thf(thm_2Einteger_2EINT__LTE__ANTSYM,axiom,
    ! [V0x: tyop_2Einteger_2Eint,V1y: tyop_2Einteger_2Eint] :
      ( (~)
      @ ( ( c_2Einteger_2Eint__le @ V0x @ V1y )
        & ( c_2Einteger_2Eint__lt @ V1y @ V0x ) ) ) ).

thf(thm_2Einteger_2EINT__LET__ANTISYM,axiom,
    ! [V0x: tyop_2Einteger_2Eint,V1y: tyop_2Einteger_2Eint] :
      ( (~)
      @ ( ( c_2Einteger_2Eint__lt @ V0x @ V1y )
        & ( c_2Einteger_2Eint__le @ V1y @ V0x ) ) ) ).

thf(thm_2Einteger_2EINT__LE__ANTISYM,axiom,
    ! [V0x: tyop_2Einteger_2Eint,V1y: tyop_2Einteger_2Eint] :
      ( ( ( c_2Einteger_2Eint__le @ V0x @ V1y )
        & ( c_2Einteger_2Eint__le @ V1y @ V0x ) )
    <=> ( V0x = V1y ) ) ).

thf(thm_2Einteger_2EINT__LE__TRANS,axiom,
    ! [V0x: tyop_2Einteger_2Eint,V1y: tyop_2Einteger_2Eint,V2z: tyop_2Einteger_2Eint] :
      ( ( ( c_2Einteger_2Eint__le @ V0x @ V1y )
        & ( c_2Einteger_2Eint__le @ V1y @ V2z ) )
     => ( c_2Einteger_2Eint__le @ V0x @ V2z ) ) ).

thf(thm_2Einteger_2EINT__LET__TRANS,axiom,
    ! [V0x: tyop_2Einteger_2Eint,V1y: tyop_2Einteger_2Eint,V2z: tyop_2Einteger_2Eint] :
      ( ( ( c_2Einteger_2Eint__le @ V0x @ V1y )
        & ( c_2Einteger_2Eint__lt @ V1y @ V2z ) )
     => ( c_2Einteger_2Eint__lt @ V0x @ V2z ) ) ).

thf(thm_2Einteger_2EINT__LTE__TRANS,axiom,
    ! [V0x: tyop_2Einteger_2Eint,V1y: tyop_2Einteger_2Eint,V2z: tyop_2Einteger_2Eint] :
      ( ( ( c_2Einteger_2Eint__lt @ V0x @ V1y )
        & ( c_2Einteger_2Eint__le @ V1y @ V2z ) )
     => ( c_2Einteger_2Eint__lt @ V0x @ V2z ) ) ).

thf(thm_2Einteger_2EINT__LT__IMP__LE,axiom,
    ! [V0x: tyop_2Einteger_2Eint,V1y: tyop_2Einteger_2Eint] :
      ( ( c_2Einteger_2Eint__lt @ V0x @ V1y )
     => ( c_2Einteger_2Eint__le @ V0x @ V1y ) ) ).

thf(thm_2Einteger_2EINT__LT__LE,axiom,
    ! [V0x: tyop_2Einteger_2Eint,V1y: tyop_2Einteger_2Eint] :
      ( ( c_2Einteger_2Eint__lt @ V0x @ V1y )
    <=> ( ( c_2Einteger_2Eint__le @ V0x @ V1y )
        & ( (~) @ ( V0x = V1y ) ) ) ) ).

thf(thm_2Einteger_2EINT__LE__LT,axiom,
    ! [V0x: tyop_2Einteger_2Eint,V1y: tyop_2Einteger_2Eint] :
      ( ( c_2Einteger_2Eint__le @ V0x @ V1y )
    <=> ( ( c_2Einteger_2Eint__lt @ V0x @ V1y )
        | ( V0x = V1y ) ) ) ).

thf(thm_2Einteger_2EINT__LE__REFL,axiom,
    ! [V0x: tyop_2Einteger_2Eint] : ( c_2Einteger_2Eint__le @ V0x @ V0x ) ).

thf(thm_2Einteger_2EINT__LTE__TOTAL,axiom,
    ! [V0x: tyop_2Einteger_2Eint,V1y: tyop_2Einteger_2Eint] :
      ( ( c_2Einteger_2Eint__lt @ V0x @ V1y )
      | ( c_2Einteger_2Eint__le @ V1y @ V0x ) ) ).

thf(thm_2Einteger_2EINT__LET__TOTAL,axiom,
    ! [V0x: tyop_2Einteger_2Eint,V1y: tyop_2Einteger_2Eint] :
      ( ( c_2Einteger_2Eint__le @ V0x @ V1y )
      | ( c_2Einteger_2Eint__lt @ V1y @ V0x ) ) ).

thf(thm_2Einteger_2EINT__LE__TOTAL,axiom,
    ! [V0x: tyop_2Einteger_2Eint,V1y: tyop_2Einteger_2Eint] :
      ( ( c_2Einteger_2Eint__le @ V0x @ V1y )
      | ( c_2Einteger_2Eint__le @ V1y @ V0x ) ) ).

thf(thm_2Einteger_2EINT__NOT__LE,axiom,
    ! [V0x: tyop_2Einteger_2Eint,V1y: tyop_2Einteger_2Eint] :
      ( ( (~) @ ( c_2Einteger_2Eint__le @ V0x @ V1y ) )
    <=> ( c_2Einteger_2Eint__lt @ V1y @ V0x ) ) ).

thf(thm_2Einteger_2EINT__LT__GT,axiom,
    ! [V0x: tyop_2Einteger_2Eint,V1y: tyop_2Einteger_2Eint] :
      ( ( c_2Einteger_2Eint__lt @ V0x @ V1y )
     => ( (~) @ ( c_2Einteger_2Eint__lt @ V1y @ V0x ) ) ) ).

thf(thm_2Einteger_2EINT__LT__ANTISYM,axiom,
    ! [V0x: tyop_2Einteger_2Eint,V1y: tyop_2Einteger_2Eint] :
      ( (~)
      @ ( ( c_2Einteger_2Eint__lt @ V0x @ V1y )
        & ( c_2Einteger_2Eint__lt @ V1y @ V0x ) ) ) ).

thf(thm_2Einteger_2EINT__NOT__LT,axiom,
    ! [V0x: tyop_2Einteger_2Eint,V1y: tyop_2Einteger_2Eint] :
      ( ( (~) @ ( c_2Einteger_2Eint__lt @ V0x @ V1y ) )
    <=> ( c_2Einteger_2Eint__le @ V1y @ V0x ) ) ).

thf(thm_2Einteger_2EINT__LT__RADD,axiom,
    ! [V0x: tyop_2Einteger_2Eint,V1y: tyop_2Einteger_2Eint,V2z: tyop_2Einteger_2Eint] :
      ( ( c_2Einteger_2Eint__lt @ ( c_2Einteger_2Eint__add @ V0x @ V2z ) @ ( c_2Einteger_2Eint__add @ V1y @ V2z ) )
      = ( c_2Einteger_2Eint__lt @ V0x @ V1y ) ) ).

thf(thm_2Einteger_2EINT__LT__LADD,axiom,
    ! [V0x: tyop_2Einteger_2Eint,V1y: tyop_2Einteger_2Eint,V2z: tyop_2Einteger_2Eint] :
      ( ( c_2Einteger_2Eint__lt @ ( c_2Einteger_2Eint__add @ V0x @ V1y ) @ ( c_2Einteger_2Eint__add @ V0x @ V2z ) )
      = ( c_2Einteger_2Eint__lt @ V1y @ V2z ) ) ).

thf(thm_2Einteger_2EINT__NEG__MUL2,axiom,
    ! [V0x: tyop_2Einteger_2Eint,V1y: tyop_2Einteger_2Eint] :
      ( ( c_2Einteger_2Eint__mul @ ( c_2Einteger_2Eint__neg @ V0x ) @ ( c_2Einteger_2Eint__neg @ V1y ) )
      = ( c_2Einteger_2Eint__mul @ V0x @ V1y ) ) ).

thf(thm_2Einteger_2EINT__NEGNEG,axiom,
    ! [V0x: tyop_2Einteger_2Eint] :
      ( ( c_2Einteger_2Eint__neg @ ( c_2Einteger_2Eint__neg @ V0x ) )
      = V0x ) ).

thf(thm_2Einteger_2EINT__NEG__RMUL,axiom,
    ! [V0x: tyop_2Einteger_2Eint,V1y: tyop_2Einteger_2Eint] :
      ( ( c_2Einteger_2Eint__neg @ ( c_2Einteger_2Eint__mul @ V0x @ V1y ) )
      = ( c_2Einteger_2Eint__mul @ V0x @ ( c_2Einteger_2Eint__neg @ V1y ) ) ) ).

thf(thm_2Einteger_2EINT__NEG__LMUL,axiom,
    ! [V0x: tyop_2Einteger_2Eint,V1y: tyop_2Einteger_2Eint] :
      ( ( c_2Einteger_2Eint__neg @ ( c_2Einteger_2Eint__mul @ V0x @ V1y ) )
      = ( c_2Einteger_2Eint__mul @ ( c_2Einteger_2Eint__neg @ V0x ) @ V1y ) ) ).

thf(thm_2Einteger_2EINT__MUL__RZERO,axiom,
    ! [V0x: tyop_2Einteger_2Eint] :
      ( ( c_2Einteger_2Eint__mul @ V0x @ ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) )
      = ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) ) ).

thf(thm_2Einteger_2EINT__MUL__LZERO,axiom,
    ! [V0x: tyop_2Einteger_2Eint] :
      ( ( c_2Einteger_2Eint__mul @ ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) @ V0x )
      = ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) ) ).

thf(thm_2Einteger_2EINT__NEG__ADD,axiom,
    ! [V0x: tyop_2Einteger_2Eint,V1y: tyop_2Einteger_2Eint] :
      ( ( c_2Einteger_2Eint__neg @ ( c_2Einteger_2Eint__add @ V0x @ V1y ) )
      = ( c_2Einteger_2Eint__add @ ( c_2Einteger_2Eint__neg @ V0x ) @ ( c_2Einteger_2Eint__neg @ V1y ) ) ) ).

thf(thm_2Einteger_2EINT__RNEG__UNIQ,axiom,
    ! [V0x: tyop_2Einteger_2Eint,V1y: tyop_2Einteger_2Eint] :
      ( ( ( c_2Einteger_2Eint__add @ V0x @ V1y )
        = ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) )
    <=> ( V1y
        = ( c_2Einteger_2Eint__neg @ V0x ) ) ) ).

thf(thm_2Einteger_2EINT__LNEG__UNIQ,axiom,
    ! [V0x: tyop_2Einteger_2Eint,V1y: tyop_2Einteger_2Eint] :
      ( ( ( c_2Einteger_2Eint__add @ V0x @ V1y )
        = ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) )
    <=> ( V0x
        = ( c_2Einteger_2Eint__neg @ V1y ) ) ) ).

thf(thm_2Einteger_2EINT__ADD__RID__UNIQ,axiom,
    ! [V0x: tyop_2Einteger_2Eint,V1y: tyop_2Einteger_2Eint] :
      ( ( ( c_2Einteger_2Eint__add @ V0x @ V1y )
        = V0x )
    <=> ( V1y
        = ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) ) ) ).

thf(thm_2Einteger_2EINT__ADD__LID__UNIQ,axiom,
    ! [V0x: tyop_2Einteger_2Eint,V1y: tyop_2Einteger_2Eint] :
      ( ( ( c_2Einteger_2Eint__add @ V0x @ V1y )
        = V1y )
    <=> ( V0x
        = ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) ) ) ).

thf(thm_2Einteger_2EINT__EQ__RADD,axiom,
    ! [V0x: tyop_2Einteger_2Eint,V1y: tyop_2Einteger_2Eint,V2z: tyop_2Einteger_2Eint] :
      ( ( ( c_2Einteger_2Eint__add @ V0x @ V2z )
        = ( c_2Einteger_2Eint__add @ V1y @ V2z ) )
    <=> ( V0x = V1y ) ) ).

thf(thm_2Einteger_2EINT__EQ__LADD,axiom,
    ! [V0x: tyop_2Einteger_2Eint,V1y: tyop_2Einteger_2Eint,V2z: tyop_2Einteger_2Eint] :
      ( ( ( c_2Einteger_2Eint__add @ V0x @ V1y )
        = ( c_2Einteger_2Eint__add @ V0x @ V2z ) )
    <=> ( V1y = V2z ) ) ).

thf(thm_2Einteger_2EINT__RDISTRIB,axiom,
    ! [V0x: tyop_2Einteger_2Eint,V1y: tyop_2Einteger_2Eint,V2z: tyop_2Einteger_2Eint] :
      ( ( c_2Einteger_2Eint__mul @ ( c_2Einteger_2Eint__add @ V0x @ V1y ) @ V2z )
      = ( c_2Einteger_2Eint__add @ ( c_2Einteger_2Eint__mul @ V0x @ V2z ) @ ( c_2Einteger_2Eint__mul @ V1y @ V2z ) ) ) ).

thf(thm_2Einteger_2EINT__MUL__RID,axiom,
    ! [V0x: tyop_2Einteger_2Eint] :
      ( ( c_2Einteger_2Eint__mul @ V0x @ ( c_2Einteger_2Eint__of__num @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) )
      = V0x ) ).

thf(thm_2Einteger_2EINT__MUL__LID,axiom,
    ! [V0x: tyop_2Einteger_2Eint] :
      ( ( c_2Einteger_2Eint__mul @ ( c_2Einteger_2Eint__of__num @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) @ V0x )
      = V0x ) ).

thf(thm_2Einteger_2EINT__ADD__RINV,axiom,
    ! [V0x: tyop_2Einteger_2Eint] :
      ( ( c_2Einteger_2Eint__add @ V0x @ ( c_2Einteger_2Eint__neg @ V0x ) )
      = ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) ) ).

thf(thm_2Einteger_2EINT__ADD__LINV,axiom,
    ! [V0x: tyop_2Einteger_2Eint] :
      ( ( c_2Einteger_2Eint__add @ ( c_2Einteger_2Eint__neg @ V0x ) @ V0x )
      = ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) ) ).

thf(thm_2Einteger_2EINT__ADD__RID,axiom,
    ! [V0x: tyop_2Einteger_2Eint] :
      ( ( c_2Einteger_2Eint__add @ V0x @ ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) )
      = V0x ) ).

thf(thm_2Einteger_2EINT__ADD__LID,axiom,
    ! [V0x: tyop_2Einteger_2Eint] :
      ( ( c_2Einteger_2Eint__add @ ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) @ V0x )
      = V0x ) ).

thf(thm_2Einteger_2EINT__1,axiom,
    ( c_2Einteger_2Eint__1
    = ( c_2Einteger_2Eint__of__num @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) ) ).

thf(thm_2Einteger_2EINT__0,axiom,
    ( c_2Einteger_2Eint__0
    = ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) ) ).

thf(thm_2Einteger_2ENUM__POSINT__EX,axiom,
    ! [V0t: tyop_2Einteger_2Eint] :
      ( ( (~) @ ( c_2Einteger_2Eint__lt @ V0t @ c_2Einteger_2Eint__0 ) )
     => ? [V1n: tyop_2Enum_2Enum] :
          ( V0t
          = ( c_2Einteger_2Eint__of__num @ V1n ) ) ) ).

thf(thm_2Einteger_2EINT__LT__MUL,axiom,
    ! [V0x: tyop_2Einteger_2Eint,V1y: tyop_2Einteger_2Eint] :
      ( ( ( c_2Einteger_2Eint__lt @ c_2Einteger_2Eint__0 @ V0x )
        & ( c_2Einteger_2Eint__lt @ c_2Einteger_2Eint__0 @ V1y ) )
     => ( c_2Einteger_2Eint__lt @ c_2Einteger_2Eint__0 @ ( c_2Einteger_2Eint__mul @ V0x @ V1y ) ) ) ).

thf(thm_2Einteger_2EINT__LT__LADD__IMP,axiom,
    ! [V0x: tyop_2Einteger_2Eint,V1y: tyop_2Einteger_2Eint,V2z: tyop_2Einteger_2Eint] :
      ( ( c_2Einteger_2Eint__lt @ V1y @ V2z )
     => ( c_2Einteger_2Eint__lt @ ( c_2Einteger_2Eint__add @ V0x @ V1y ) @ ( c_2Einteger_2Eint__add @ V0x @ V2z ) ) ) ).

thf(thm_2Einteger_2EINT__LT__TRANS,axiom,
    ! [V0x: tyop_2Einteger_2Eint,V1y: tyop_2Einteger_2Eint,V2z: tyop_2Einteger_2Eint] :
      ( ( ( c_2Einteger_2Eint__lt @ V0x @ V1y )
        & ( c_2Einteger_2Eint__lt @ V1y @ V2z ) )
     => ( c_2Einteger_2Eint__lt @ V0x @ V2z ) ) ).

thf(thm_2Einteger_2EINT__LT__REFL,axiom,
    ! [V0x: tyop_2Einteger_2Eint] : ( (~) @ ( c_2Einteger_2Eint__lt @ V0x @ V0x ) ) ).

thf(thm_2Einteger_2EINT__LT__TOTAL,axiom,
    ! [V0x: tyop_2Einteger_2Eint,V1y: tyop_2Einteger_2Eint] :
      ( ( V0x = V1y )
      | ( c_2Einteger_2Eint__lt @ V0x @ V1y )
      | ( c_2Einteger_2Eint__lt @ V1y @ V0x ) ) ).

thf(thm_2Einteger_2EINT__LDISTRIB,axiom,
    ! [V0z: tyop_2Einteger_2Eint,V1y: tyop_2Einteger_2Eint,V2x: tyop_2Einteger_2Eint] :
      ( ( c_2Einteger_2Eint__mul @ V2x @ ( c_2Einteger_2Eint__add @ V1y @ V0z ) )
      = ( c_2Einteger_2Eint__add @ ( c_2Einteger_2Eint__mul @ V2x @ V1y ) @ ( c_2Einteger_2Eint__mul @ V2x @ V0z ) ) ) ).

thf(thm_2Einteger_2EINT__MUL__ASSOC,axiom,
    ! [V0z: tyop_2Einteger_2Eint,V1y: tyop_2Einteger_2Eint,V2x: tyop_2Einteger_2Eint] :
      ( ( c_2Einteger_2Eint__mul @ V2x @ ( c_2Einteger_2Eint__mul @ V1y @ V0z ) )
      = ( c_2Einteger_2Eint__mul @ ( c_2Einteger_2Eint__mul @ V2x @ V1y ) @ V0z ) ) ).

thf(thm_2Einteger_2EINT__ADD__ASSOC,axiom,
    ! [V0z: tyop_2Einteger_2Eint,V1y: tyop_2Einteger_2Eint,V2x: tyop_2Einteger_2Eint] :
      ( ( c_2Einteger_2Eint__add @ V2x @ ( c_2Einteger_2Eint__add @ V1y @ V0z ) )
      = ( c_2Einteger_2Eint__add @ ( c_2Einteger_2Eint__add @ V2x @ V1y ) @ V0z ) ) ).

thf(thm_2Einteger_2EINT__MUL__COMM,axiom,
    ! [V0y: tyop_2Einteger_2Eint,V1x: tyop_2Einteger_2Eint] :
      ( ( c_2Einteger_2Eint__mul @ V1x @ V0y )
      = ( c_2Einteger_2Eint__mul @ V0y @ V1x ) ) ).

thf(thm_2Einteger_2EINT__MUL__SYM,axiom,
    ! [V0y: tyop_2Einteger_2Eint,V1x: tyop_2Einteger_2Eint] :
      ( ( c_2Einteger_2Eint__mul @ V1x @ V0y )
      = ( c_2Einteger_2Eint__mul @ V0y @ V1x ) ) ).

thf(thm_2Einteger_2EINT__ADD__COMM,axiom,
    ! [V0y: tyop_2Einteger_2Eint,V1x: tyop_2Einteger_2Eint] :
      ( ( c_2Einteger_2Eint__add @ V1x @ V0y )
      = ( c_2Einteger_2Eint__add @ V0y @ V1x ) ) ).

thf(thm_2Einteger_2EINT__ADD__SYM,axiom,
    ! [V0y: tyop_2Einteger_2Eint,V1x: tyop_2Einteger_2Eint] :
      ( ( c_2Einteger_2Eint__add @ V1x @ V0y )
      = ( c_2Einteger_2Eint__add @ V0y @ V1x ) ) ).

thf(thm_2Einteger_2EINT__10,axiom,
    (~) @ ( c_2Einteger_2Eint__1 = c_2Einteger_2Eint__0 ) ).

thf(thm_2Einteger_2EEQ__LADD,axiom,
    ! [V0x: tyop_2Enum_2Enum,V1y: tyop_2Enum_2Enum,V2z: tyop_2Enum_2Enum] :
      ( ( ( c_2Earithmetic_2E_2B @ V0x @ V1y )
        = ( c_2Earithmetic_2E_2B @ V0x @ V2z ) )
    <=> ( V1y = V2z ) ) ).

thf(thm_2Einteger_2EEQ__ADDL,axiom,
    ! [V0x: tyop_2Enum_2Enum,V1y: tyop_2Enum_2Enum] :
      ( ( V0x
        = ( c_2Earithmetic_2E_2B @ V0x @ V1y ) )
    <=> ( V1y = c_2Enum_2E0 ) ) ).

thf(thm_2Einteger_2ELT__LADD,axiom,
    ! [V0x: tyop_2Enum_2Enum,V1y: tyop_2Enum_2Enum,V2z: tyop_2Enum_2Enum] :
      ( ( c_2Eprim__rec_2E_3C @ ( c_2Earithmetic_2E_2B @ V0x @ V1y ) @ ( c_2Earithmetic_2E_2B @ V0x @ V2z ) )
      = ( c_2Eprim__rec_2E_3C @ V1y @ V2z ) ) ).

thf(thm_2Einteger_2ELT__ADDL,axiom,
    ! [V0x: tyop_2Enum_2Enum,V1y: tyop_2Enum_2Enum] :
      ( ( c_2Eprim__rec_2E_3C @ V0x @ ( c_2Earithmetic_2E_2B @ V0x @ V1y ) )
      = ( c_2Eprim__rec_2E_3C @ c_2Enum_2E0 @ V1y ) ) ).

thf(thm_2Einteger_2ELT__ADDR,axiom,
    ! [V0x: tyop_2Enum_2Enum,V1y: tyop_2Enum_2Enum] : ( (~) @ ( c_2Eprim__rec_2E_3C @ ( c_2Earithmetic_2E_2B @ V0x @ V1y ) @ V0x ) ) ).

thf(thm_2Einteger_2ELT__ADD2,axiom,
    ! [V0x1: tyop_2Enum_2Enum,V1x2: tyop_2Enum_2Enum,V2y1: tyop_2Enum_2Enum,V3y2: tyop_2Enum_2Enum] :
      ( ( ( c_2Eprim__rec_2E_3C @ V0x1 @ V2y1 )
        & ( c_2Eprim__rec_2E_3C @ V1x2 @ V3y2 ) )
     => ( c_2Eprim__rec_2E_3C @ ( c_2Earithmetic_2E_2B @ V0x1 @ V1x2 ) @ ( c_2Earithmetic_2E_2B @ V2y1 @ V3y2 ) ) ) ).

thf(thm_2Einteger_2ETINT__EQ__REFL,axiom,
    ! [V0x: tyop_2Epair_2Eprod @ tyop_2Enum_2Enum @ tyop_2Enum_2Enum] : ( c_2Einteger_2Etint__eq @ V0x @ V0x ) ).

thf(thm_2Einteger_2ETINT__EQ__SYM,axiom,
    ! [V0x: tyop_2Epair_2Eprod @ tyop_2Enum_2Enum @ tyop_2Enum_2Enum,V1y: tyop_2Epair_2Eprod @ tyop_2Enum_2Enum @ tyop_2Enum_2Enum] :
      ( ( c_2Einteger_2Etint__eq @ V0x @ V1y )
      = ( c_2Einteger_2Etint__eq @ V1y @ V0x ) ) ).

thf(thm_2Einteger_2ETINT__EQ__TRANS,axiom,
    ! [V0x: tyop_2Epair_2Eprod @ tyop_2Enum_2Enum @ tyop_2Enum_2Enum,V1y: tyop_2Epair_2Eprod @ tyop_2Enum_2Enum @ tyop_2Enum_2Enum,V2z: tyop_2Epair_2Eprod @ tyop_2Enum_2Enum @ tyop_2Enum_2Enum] :
      ( ( ( c_2Einteger_2Etint__eq @ V0x @ V1y )
        & ( c_2Einteger_2Etint__eq @ V1y @ V2z ) )
     => ( c_2Einteger_2Etint__eq @ V0x @ V2z ) ) ).

thf(thm_2Einteger_2ETINT__EQ__EQUIV,axiom,
    ! [V0p: tyop_2Epair_2Eprod @ tyop_2Enum_2Enum @ tyop_2Enum_2Enum,V1q: tyop_2Epair_2Eprod @ tyop_2Enum_2Enum @ tyop_2Enum_2Enum] :
      ( ( c_2Einteger_2Etint__eq @ V0p @ V1q )
    <=> ( ( c_2Einteger_2Etint__eq @ V0p )
        = ( c_2Einteger_2Etint__eq @ V1q ) ) ) ).

thf(thm_2Einteger_2ETINT__EQ__AP,axiom,
    ! [V0p: tyop_2Epair_2Eprod @ tyop_2Enum_2Enum @ tyop_2Enum_2Enum,V1q: tyop_2Epair_2Eprod @ tyop_2Enum_2Enum @ tyop_2Enum_2Enum] :
      ( ( V0p = V1q )
     => ( c_2Einteger_2Etint__eq @ V0p @ V1q ) ) ).

thf(thm_2Einteger_2ETINT__10,axiom,
    (~) @ ( c_2Einteger_2Etint__eq @ c_2Einteger_2Etint__1 @ c_2Einteger_2Etint__0 ) ).

thf(thm_2Einteger_2ETINT__ADD__SYM,axiom,
    ! [V0x: tyop_2Epair_2Eprod @ tyop_2Enum_2Enum @ tyop_2Enum_2Enum,V1y: tyop_2Epair_2Eprod @ tyop_2Enum_2Enum @ tyop_2Enum_2Enum] :
      ( ( c_2Einteger_2Etint__add @ V0x @ V1y )
      = ( c_2Einteger_2Etint__add @ V1y @ V0x ) ) ).

thf(thm_2Einteger_2ETINT__MUL__SYM,axiom,
    ! [V0x: tyop_2Epair_2Eprod @ tyop_2Enum_2Enum @ tyop_2Enum_2Enum,V1y: tyop_2Epair_2Eprod @ tyop_2Enum_2Enum @ tyop_2Enum_2Enum] :
      ( ( c_2Einteger_2Etint__mul @ V0x @ V1y )
      = ( c_2Einteger_2Etint__mul @ V1y @ V0x ) ) ).

thf(thm_2Einteger_2ETINT__ADD__ASSOC,axiom,
    ! [V0x: tyop_2Epair_2Eprod @ tyop_2Enum_2Enum @ tyop_2Enum_2Enum,V1y: tyop_2Epair_2Eprod @ tyop_2Enum_2Enum @ tyop_2Enum_2Enum,V2z: tyop_2Epair_2Eprod @ tyop_2Enum_2Enum @ tyop_2Enum_2Enum] :
      ( ( c_2Einteger_2Etint__add @ V0x @ ( c_2Einteger_2Etint__add @ V1y @ V2z ) )
      = ( c_2Einteger_2Etint__add @ ( c_2Einteger_2Etint__add @ V0x @ V1y ) @ V2z ) ) ).

thf(thm_2Einteger_2ETINT__MUL__ASSOC,axiom,
    ! [V0x: tyop_2Epair_2Eprod @ tyop_2Enum_2Enum @ tyop_2Enum_2Enum,V1y: tyop_2Epair_2Eprod @ tyop_2Enum_2Enum @ tyop_2Enum_2Enum,V2z: tyop_2Epair_2Eprod @ tyop_2Enum_2Enum @ tyop_2Enum_2Enum] :
      ( ( c_2Einteger_2Etint__mul @ V0x @ ( c_2Einteger_2Etint__mul @ V1y @ V2z ) )
      = ( c_2Einteger_2Etint__mul @ ( c_2Einteger_2Etint__mul @ V0x @ V1y ) @ V2z ) ) ).

thf(thm_2Einteger_2ETINT__LDISTRIB,axiom,
    ! [V0x: tyop_2Epair_2Eprod @ tyop_2Enum_2Enum @ tyop_2Enum_2Enum,V1y: tyop_2Epair_2Eprod @ tyop_2Enum_2Enum @ tyop_2Enum_2Enum,V2z: tyop_2Epair_2Eprod @ tyop_2Enum_2Enum @ tyop_2Enum_2Enum] :
      ( ( c_2Einteger_2Etint__mul @ V0x @ ( c_2Einteger_2Etint__add @ V1y @ V2z ) )
      = ( c_2Einteger_2Etint__add @ ( c_2Einteger_2Etint__mul @ V0x @ V1y ) @ ( c_2Einteger_2Etint__mul @ V0x @ V2z ) ) ) ).

thf(thm_2Einteger_2ETINT__ADD__LID,axiom,
    ! [V0x: tyop_2Epair_2Eprod @ tyop_2Enum_2Enum @ tyop_2Enum_2Enum] : ( c_2Einteger_2Etint__eq @ ( c_2Einteger_2Etint__add @ c_2Einteger_2Etint__0 @ V0x ) @ V0x ) ).

thf(thm_2Einteger_2ETINT__MUL__LID,axiom,
    ! [V0x: tyop_2Epair_2Eprod @ tyop_2Enum_2Enum @ tyop_2Enum_2Enum] : ( c_2Einteger_2Etint__eq @ ( c_2Einteger_2Etint__mul @ c_2Einteger_2Etint__1 @ V0x ) @ V0x ) ).

thf(thm_2Einteger_2ETINT__ADD__LINV,axiom,
    ! [V0x: tyop_2Epair_2Eprod @ tyop_2Enum_2Enum @ tyop_2Enum_2Enum] : ( c_2Einteger_2Etint__eq @ ( c_2Einteger_2Etint__add @ ( c_2Einteger_2Etint__neg @ V0x ) @ V0x ) @ c_2Einteger_2Etint__0 ) ).

thf(thm_2Einteger_2ETINT__LT__TOTAL,axiom,
    ! [V0x: tyop_2Epair_2Eprod @ tyop_2Enum_2Enum @ tyop_2Enum_2Enum,V1y: tyop_2Epair_2Eprod @ tyop_2Enum_2Enum @ tyop_2Enum_2Enum] :
      ( ( c_2Einteger_2Etint__eq @ V0x @ V1y )
      | ( c_2Einteger_2Etint__lt @ V0x @ V1y )
      | ( c_2Einteger_2Etint__lt @ V1y @ V0x ) ) ).

thf(thm_2Einteger_2ETINT__LT__REFL,axiom,
    ! [V0x: tyop_2Epair_2Eprod @ tyop_2Enum_2Enum @ tyop_2Enum_2Enum] : ( (~) @ ( c_2Einteger_2Etint__lt @ V0x @ V0x ) ) ).

thf(thm_2Einteger_2ETINT__LT__TRANS,axiom,
    ! [V0x: tyop_2Epair_2Eprod @ tyop_2Enum_2Enum @ tyop_2Enum_2Enum,V1y: tyop_2Epair_2Eprod @ tyop_2Enum_2Enum @ tyop_2Enum_2Enum,V2z: tyop_2Epair_2Eprod @ tyop_2Enum_2Enum @ tyop_2Enum_2Enum] :
      ( ( ( c_2Einteger_2Etint__lt @ V0x @ V1y )
        & ( c_2Einteger_2Etint__lt @ V1y @ V2z ) )
     => ( c_2Einteger_2Etint__lt @ V0x @ V2z ) ) ).

thf(thm_2Einteger_2ETINT__LT__ADD,axiom,
    ! [V0x: tyop_2Epair_2Eprod @ tyop_2Enum_2Enum @ tyop_2Enum_2Enum,V1y: tyop_2Epair_2Eprod @ tyop_2Enum_2Enum @ tyop_2Enum_2Enum,V2z: tyop_2Epair_2Eprod @ tyop_2Enum_2Enum @ tyop_2Enum_2Enum] :
      ( ( c_2Einteger_2Etint__lt @ V1y @ V2z )
     => ( c_2Einteger_2Etint__lt @ ( c_2Einteger_2Etint__add @ V0x @ V1y ) @ ( c_2Einteger_2Etint__add @ V0x @ V2z ) ) ) ).

thf(thm_2Einteger_2ETINT__LT__MUL,axiom,
    ! [V0x: tyop_2Epair_2Eprod @ tyop_2Enum_2Enum @ tyop_2Enum_2Enum,V1y: tyop_2Epair_2Eprod @ tyop_2Enum_2Enum @ tyop_2Enum_2Enum] :
      ( ( ( c_2Einteger_2Etint__lt @ c_2Einteger_2Etint__0 @ V0x )
        & ( c_2Einteger_2Etint__lt @ c_2Einteger_2Etint__0 @ V1y ) )
     => ( c_2Einteger_2Etint__lt @ c_2Einteger_2Etint__0 @ ( c_2Einteger_2Etint__mul @ V0x @ V1y ) ) ) ).

thf(thm_2Einteger_2ETINT__NEG__WELLDEF,axiom,
    ! [V0x1: tyop_2Epair_2Eprod @ tyop_2Enum_2Enum @ tyop_2Enum_2Enum,V1x2: tyop_2Epair_2Eprod @ tyop_2Enum_2Enum @ tyop_2Enum_2Enum] :
      ( ( c_2Einteger_2Etint__eq @ V0x1 @ V1x2 )
     => ( c_2Einteger_2Etint__eq @ ( c_2Einteger_2Etint__neg @ V0x1 ) @ ( c_2Einteger_2Etint__neg @ V1x2 ) ) ) ).

thf(thm_2Einteger_2ETINT__ADD__WELLDEFR,axiom,
    ! [V0x1: tyop_2Epair_2Eprod @ tyop_2Enum_2Enum @ tyop_2Enum_2Enum,V1x2: tyop_2Epair_2Eprod @ tyop_2Enum_2Enum @ tyop_2Enum_2Enum,V2y: tyop_2Epair_2Eprod @ tyop_2Enum_2Enum @ tyop_2Enum_2Enum] :
      ( ( c_2Einteger_2Etint__eq @ V0x1 @ V1x2 )
     => ( c_2Einteger_2Etint__eq @ ( c_2Einteger_2Etint__add @ V0x1 @ V2y ) @ ( c_2Einteger_2Etint__add @ V1x2 @ V2y ) ) ) ).

thf(thm_2Einteger_2ETINT__ADD__WELLDEF,axiom,
    ! [V0x1: tyop_2Epair_2Eprod @ tyop_2Enum_2Enum @ tyop_2Enum_2Enum,V1x2: tyop_2Epair_2Eprod @ tyop_2Enum_2Enum @ tyop_2Enum_2Enum,V2y1: tyop_2Epair_2Eprod @ tyop_2Enum_2Enum @ tyop_2Enum_2Enum,V3y2: tyop_2Epair_2Eprod @ tyop_2Enum_2Enum @ tyop_2Enum_2Enum] :
      ( ( ( c_2Einteger_2Etint__eq @ V0x1 @ V1x2 )
        & ( c_2Einteger_2Etint__eq @ V2y1 @ V3y2 ) )
     => ( c_2Einteger_2Etint__eq @ ( c_2Einteger_2Etint__add @ V0x1 @ V2y1 ) @ ( c_2Einteger_2Etint__add @ V1x2 @ V3y2 ) ) ) ).

thf(thm_2Einteger_2ETINT__MUL__WELLDEFR,axiom,
    ! [V0x1: tyop_2Epair_2Eprod @ tyop_2Enum_2Enum @ tyop_2Enum_2Enum,V1x2: tyop_2Epair_2Eprod @ tyop_2Enum_2Enum @ tyop_2Enum_2Enum,V2y: tyop_2Epair_2Eprod @ tyop_2Enum_2Enum @ tyop_2Enum_2Enum] :
      ( ( c_2Einteger_2Etint__eq @ V0x1 @ V1x2 )
     => ( c_2Einteger_2Etint__eq @ ( c_2Einteger_2Etint__mul @ V0x1 @ V2y ) @ ( c_2Einteger_2Etint__mul @ V1x2 @ V2y ) ) ) ).

thf(thm_2Einteger_2ETINT__MUL__WELLDEF,axiom,
    ! [V0x1: tyop_2Epair_2Eprod @ tyop_2Enum_2Enum @ tyop_2Enum_2Enum,V1x2: tyop_2Epair_2Eprod @ tyop_2Enum_2Enum @ tyop_2Enum_2Enum,V2y1: tyop_2Epair_2Eprod @ tyop_2Enum_2Enum @ tyop_2Enum_2Enum,V3y2: tyop_2Epair_2Eprod @ tyop_2Enum_2Enum @ tyop_2Enum_2Enum] :
      ( ( ( c_2Einteger_2Etint__eq @ V0x1 @ V1x2 )
        & ( c_2Einteger_2Etint__eq @ V2y1 @ V3y2 ) )
     => ( c_2Einteger_2Etint__eq @ ( c_2Einteger_2Etint__mul @ V0x1 @ V2y1 ) @ ( c_2Einteger_2Etint__mul @ V1x2 @ V3y2 ) ) ) ).

thf(thm_2Einteger_2ETINT__LT__WELLDEFR,axiom,
    ! [V0x1: tyop_2Epair_2Eprod @ tyop_2Enum_2Enum @ tyop_2Enum_2Enum,V1x2: tyop_2Epair_2Eprod @ tyop_2Enum_2Enum @ tyop_2Enum_2Enum,V2y: tyop_2Epair_2Eprod @ tyop_2Enum_2Enum @ tyop_2Enum_2Enum] :
      ( ( c_2Einteger_2Etint__eq @ V0x1 @ V1x2 )
     => ( ( c_2Einteger_2Etint__lt @ V0x1 @ V2y )
        = ( c_2Einteger_2Etint__lt @ V1x2 @ V2y ) ) ) ).

thf(thm_2Einteger_2ETINT__LT__WELLDEFL,axiom,
    ! [V0x: tyop_2Epair_2Eprod @ tyop_2Enum_2Enum @ tyop_2Enum_2Enum,V1y1: tyop_2Epair_2Eprod @ tyop_2Enum_2Enum @ tyop_2Enum_2Enum,V2y2: tyop_2Epair_2Eprod @ tyop_2Enum_2Enum @ tyop_2Enum_2Enum] :
      ( ( c_2Einteger_2Etint__eq @ V1y1 @ V2y2 )
     => ( ( c_2Einteger_2Etint__lt @ V0x @ V1y1 )
        = ( c_2Einteger_2Etint__lt @ V0x @ V2y2 ) ) ) ).

thf(thm_2Einteger_2ETINT__LT__WELLDEF,axiom,
    ! [V0x1: tyop_2Epair_2Eprod @ tyop_2Enum_2Enum @ tyop_2Enum_2Enum,V1x2: tyop_2Epair_2Eprod @ tyop_2Enum_2Enum @ tyop_2Enum_2Enum,V2y1: tyop_2Epair_2Eprod @ tyop_2Enum_2Enum @ tyop_2Enum_2Enum,V3y2: tyop_2Epair_2Eprod @ tyop_2Enum_2Enum @ tyop_2Enum_2Enum] :
      ( ( ( c_2Einteger_2Etint__eq @ V0x1 @ V1x2 )
        & ( c_2Einteger_2Etint__eq @ V2y1 @ V3y2 ) )
     => ( ( c_2Einteger_2Etint__lt @ V0x1 @ V2y1 )
        = ( c_2Einteger_2Etint__lt @ V1x2 @ V3y2 ) ) ) ).

thf(thm_2Einteger_2Etint__of__num__eq,axiom,
    ! [V0n: tyop_2Enum_2Enum] :
      ( ( c_2Epair_2EFST @ tyop_2Enum_2Enum @ tyop_2Enum_2Enum @ ( c_2Einteger_2Etint__of__num @ V0n ) )
      = ( c_2Earithmetic_2E_2B @ ( c_2Epair_2ESND @ tyop_2Enum_2Enum @ tyop_2Enum_2Enum @ ( c_2Einteger_2Etint__of__num @ V0n ) ) @ V0n ) ) ).

thf(thm_2Einteger_2ETINT__INJ,axiom,
    ! [V0m: tyop_2Enum_2Enum,V1n: tyop_2Enum_2Enum] :
      ( ( c_2Einteger_2Etint__eq @ ( c_2Einteger_2Etint__of__num @ V0m ) @ ( c_2Einteger_2Etint__of__num @ V1n ) )
    <=> ( V0m = V1n ) ) ).

thf(thm_2Einteger_2ENUM__POSTINT__EX,axiom,
    ! [V0t: tyop_2Epair_2Eprod @ tyop_2Enum_2Enum @ tyop_2Enum_2Enum] :
      ( ( (~) @ ( c_2Einteger_2Etint__lt @ V0t @ c_2Einteger_2Etint__0 ) )
     => ? [V1n: tyop_2Enum_2Enum] : ( c_2Einteger_2Etint__eq @ V0t @ ( c_2Einteger_2Etint__of__num @ V1n ) ) ) ).

thf(thm_2Einteger_2Eint__ABS__REP__CLASS,axiom,
    ( ! [V0a: tyop_2Einteger_2Eint] :
        ( ( c_2Einteger_2Eint__ABS__CLASS @ ( c_2Einteger_2Eint__REP__CLASS @ V0a ) )
        = V0a )
    & ! [V1c: ( tyop_2Epair_2Eprod @ tyop_2Enum_2Enum @ tyop_2Enum_2Enum ) > $o] :
        ( ? [V2r: tyop_2Epair_2Eprod @ tyop_2Enum_2Enum @ tyop_2Enum_2Enum] :
            ( ( c_2Einteger_2Etint__eq @ V2r @ V2r )
            & ( V1c
              = ( c_2Einteger_2Etint__eq @ V2r ) ) )
      <=> ( ( c_2Einteger_2Eint__REP__CLASS @ ( c_2Einteger_2Eint__ABS__CLASS @ V1c ) )
          = V1c ) ) ) ).

thf(thm_2Einteger_2Eint__QUOTIENT,axiom,
    c_2Equotient_2EQUOTIENT @ ( tyop_2Epair_2Eprod @ tyop_2Enum_2Enum @ tyop_2Enum_2Enum ) @ tyop_2Einteger_2Eint @ c_2Einteger_2Etint__eq @ c_2Einteger_2Eint__ABS @ c_2Einteger_2Eint__REP ).

thf(thm_2Einteger_2Eint__of__num,axiom,
    ( ( ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 )
      = c_2Einteger_2Eint__0 )
    & ! [V0n: tyop_2Enum_2Enum] :
        ( ( c_2Einteger_2Eint__of__num @ ( c_2Enum_2ESUC @ V0n ) )
        = ( c_2Einteger_2Eint__add @ ( c_2Einteger_2Eint__of__num @ V0n ) @ c_2Einteger_2Eint__1 ) ) ) ).

thf(thm_2Einteger_2EINT__INJ,axiom,
    ! [V0m: tyop_2Enum_2Enum,V1n: tyop_2Enum_2Enum] :
      ( ( ( c_2Einteger_2Eint__of__num @ V0m )
        = ( c_2Einteger_2Eint__of__num @ V1n ) )
    <=> ( V0m = V1n ) ) ).

thf(thm_2Einteger_2EINT__ADD,axiom,
    ! [V0m: tyop_2Enum_2Enum,V1n: tyop_2Enum_2Enum] :
      ( ( c_2Einteger_2Eint__add @ ( c_2Einteger_2Eint__of__num @ V0m ) @ ( c_2Einteger_2Eint__of__num @ V1n ) )
      = ( c_2Einteger_2Eint__of__num @ ( c_2Earithmetic_2E_2B @ V0m @ V1n ) ) ) ).

thf(thm_2Einteger_2EINT__MUL,axiom,
    ! [V0m: tyop_2Enum_2Enum,V1n: tyop_2Enum_2Enum] :
      ( ( c_2Einteger_2Eint__mul @ ( c_2Einteger_2Eint__of__num @ V0m ) @ ( c_2Einteger_2Eint__of__num @ V1n ) )
      = ( c_2Einteger_2Eint__of__num @ ( c_2Earithmetic_2E_2A @ V0m @ V1n ) ) ) ).

thf(thm_2Einteger_2EINT__LT__NZ,axiom,
    ! [V0n: tyop_2Enum_2Enum] :
      ( ( (~)
        @ ( ( c_2Einteger_2Eint__of__num @ V0n )
          = ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) ) )
    <=> ( c_2Einteger_2Eint__lt @ ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) @ ( c_2Einteger_2Eint__of__num @ V0n ) ) ) ).

thf(thm_2Einteger_2EINT__NZ__IMP__LT,axiom,
    ! [V0n: tyop_2Enum_2Enum] :
      ( ( (~) @ ( V0n = c_2Enum_2E0 ) )
     => ( c_2Einteger_2Eint__lt @ ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) @ ( c_2Einteger_2Eint__of__num @ V0n ) ) ) ).

thf(thm_2Einteger_2EINT__DOUBLE,axiom,
    ! [V0x: tyop_2Einteger_2Eint] :
      ( ( c_2Einteger_2Eint__add @ V0x @ V0x )
      = ( c_2Einteger_2Eint__mul @ ( c_2Einteger_2Eint__of__num @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT2 @ c_2Earithmetic_2EZERO ) ) ) @ V0x ) ) ).

thf(thm_2Einteger_2EINT__SUB__SUB,axiom,
    ! [V0x: tyop_2Einteger_2Eint,V1y: tyop_2Einteger_2Eint] :
      ( ( c_2Einteger_2Eint__sub @ ( c_2Einteger_2Eint__sub @ V0x @ V1y ) @ V0x )
      = ( c_2Einteger_2Eint__neg @ V1y ) ) ).

thf(thm_2Einteger_2EINT__LT__ADD__SUB,axiom,
    ! [V0x: tyop_2Einteger_2Eint,V1y: tyop_2Einteger_2Eint,V2z: tyop_2Einteger_2Eint] :
      ( ( c_2Einteger_2Eint__lt @ ( c_2Einteger_2Eint__add @ V0x @ V1y ) @ V2z )
      = ( c_2Einteger_2Eint__lt @ V0x @ ( c_2Einteger_2Eint__sub @ V2z @ V1y ) ) ) ).

thf(thm_2Einteger_2EINT__LT__SUB__RADD,axiom,
    ! [V0x: tyop_2Einteger_2Eint,V1y: tyop_2Einteger_2Eint,V2z: tyop_2Einteger_2Eint] :
      ( ( c_2Einteger_2Eint__lt @ ( c_2Einteger_2Eint__sub @ V0x @ V1y ) @ V2z )
      = ( c_2Einteger_2Eint__lt @ V0x @ ( c_2Einteger_2Eint__add @ V2z @ V1y ) ) ) ).

thf(thm_2Einteger_2EINT__LT__SUB__LADD,axiom,
    ! [V0x: tyop_2Einteger_2Eint,V1y: tyop_2Einteger_2Eint,V2z: tyop_2Einteger_2Eint] :
      ( ( c_2Einteger_2Eint__lt @ V0x @ ( c_2Einteger_2Eint__sub @ V1y @ V2z ) )
      = ( c_2Einteger_2Eint__lt @ ( c_2Einteger_2Eint__add @ V0x @ V2z ) @ V1y ) ) ).

thf(thm_2Einteger_2EINT__LE__SUB__LADD,axiom,
    ! [V0x: tyop_2Einteger_2Eint,V1y: tyop_2Einteger_2Eint,V2z: tyop_2Einteger_2Eint] :
      ( ( c_2Einteger_2Eint__le @ V0x @ ( c_2Einteger_2Eint__sub @ V1y @ V2z ) )
      = ( c_2Einteger_2Eint__le @ ( c_2Einteger_2Eint__add @ V0x @ V2z ) @ V1y ) ) ).

thf(thm_2Einteger_2EINT__LE__SUB__RADD,axiom,
    ! [V0x: tyop_2Einteger_2Eint,V1y: tyop_2Einteger_2Eint,V2z: tyop_2Einteger_2Eint] :
      ( ( c_2Einteger_2Eint__le @ ( c_2Einteger_2Eint__sub @ V0x @ V1y ) @ V2z )
      = ( c_2Einteger_2Eint__le @ V0x @ ( c_2Einteger_2Eint__add @ V2z @ V1y ) ) ) ).

thf(thm_2Einteger_2EINT__LT__NEG,axiom,
    ! [V0x: tyop_2Einteger_2Eint,V1y: tyop_2Einteger_2Eint] :
      ( ( c_2Einteger_2Eint__lt @ ( c_2Einteger_2Eint__neg @ V0x ) @ ( c_2Einteger_2Eint__neg @ V1y ) )
      = ( c_2Einteger_2Eint__lt @ V1y @ V0x ) ) ).

thf(thm_2Einteger_2EINT__LE__NEG,axiom,
    ! [V0x: tyop_2Einteger_2Eint,V1y: tyop_2Einteger_2Eint] :
      ( ( c_2Einteger_2Eint__le @ ( c_2Einteger_2Eint__neg @ V0x ) @ ( c_2Einteger_2Eint__neg @ V1y ) )
      = ( c_2Einteger_2Eint__le @ V1y @ V0x ) ) ).

thf(thm_2Einteger_2EINT__ADD2__SUB2,axiom,
    ! [V0a: tyop_2Einteger_2Eint,V1b: tyop_2Einteger_2Eint,V2c: tyop_2Einteger_2Eint,V3d: tyop_2Einteger_2Eint] :
      ( ( c_2Einteger_2Eint__sub @ ( c_2Einteger_2Eint__add @ V0a @ V1b ) @ ( c_2Einteger_2Eint__add @ V2c @ V3d ) )
      = ( c_2Einteger_2Eint__add @ ( c_2Einteger_2Eint__sub @ V0a @ V2c ) @ ( c_2Einteger_2Eint__sub @ V1b @ V3d ) ) ) ).

thf(thm_2Einteger_2EINT__SUB__LZERO,axiom,
    ! [V0x: tyop_2Einteger_2Eint] :
      ( ( c_2Einteger_2Eint__sub @ ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) @ V0x )
      = ( c_2Einteger_2Eint__neg @ V0x ) ) ).

thf(thm_2Einteger_2EINT__SUB__RZERO,axiom,
    ! [V0x: tyop_2Einteger_2Eint] :
      ( ( c_2Einteger_2Eint__sub @ V0x @ ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) )
      = V0x ) ).

thf(thm_2Einteger_2EINT__LET__ADD2,axiom,
    ! [V0w: tyop_2Einteger_2Eint,V1x: tyop_2Einteger_2Eint,V2y: tyop_2Einteger_2Eint,V3z: tyop_2Einteger_2Eint] :
      ( ( ( c_2Einteger_2Eint__le @ V0w @ V1x )
        & ( c_2Einteger_2Eint__lt @ V2y @ V3z ) )
     => ( c_2Einteger_2Eint__lt @ ( c_2Einteger_2Eint__add @ V0w @ V2y ) @ ( c_2Einteger_2Eint__add @ V1x @ V3z ) ) ) ).

thf(thm_2Einteger_2EINT__LTE__ADD2,axiom,
    ! [V0w: tyop_2Einteger_2Eint,V1x: tyop_2Einteger_2Eint,V2y: tyop_2Einteger_2Eint,V3z: tyop_2Einteger_2Eint] :
      ( ( ( c_2Einteger_2Eint__lt @ V0w @ V1x )
        & ( c_2Einteger_2Eint__le @ V2y @ V3z ) )
     => ( c_2Einteger_2Eint__lt @ ( c_2Einteger_2Eint__add @ V0w @ V2y ) @ ( c_2Einteger_2Eint__add @ V1x @ V3z ) ) ) ).

thf(thm_2Einteger_2EINT__LET__ADD,axiom,
    ! [V0x: tyop_2Einteger_2Eint,V1y: tyop_2Einteger_2Eint] :
      ( ( ( c_2Einteger_2Eint__le @ ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) @ V0x )
        & ( c_2Einteger_2Eint__lt @ ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) @ V1y ) )
     => ( c_2Einteger_2Eint__lt @ ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) @ ( c_2Einteger_2Eint__add @ V0x @ V1y ) ) ) ).

thf(thm_2Einteger_2EINT__LTE__ADD,axiom,
    ! [V0x: tyop_2Einteger_2Eint,V1y: tyop_2Einteger_2Eint] :
      ( ( ( c_2Einteger_2Eint__lt @ ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) @ V0x )
        & ( c_2Einteger_2Eint__le @ ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) @ V1y ) )
     => ( c_2Einteger_2Eint__lt @ ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) @ ( c_2Einteger_2Eint__add @ V0x @ V1y ) ) ) ).

thf(thm_2Einteger_2EINT__LT__MUL2,axiom,
    ! [V0x1: tyop_2Einteger_2Eint,V1x2: tyop_2Einteger_2Eint,V2y1: tyop_2Einteger_2Eint,V3y2: tyop_2Einteger_2Eint] :
      ( ( ( c_2Einteger_2Eint__le @ ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) @ V0x1 )
        & ( c_2Einteger_2Eint__le @ ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) @ V2y1 )
        & ( c_2Einteger_2Eint__lt @ V0x1 @ V1x2 )
        & ( c_2Einteger_2Eint__lt @ V2y1 @ V3y2 ) )
     => ( c_2Einteger_2Eint__lt @ ( c_2Einteger_2Eint__mul @ V0x1 @ V2y1 ) @ ( c_2Einteger_2Eint__mul @ V1x2 @ V3y2 ) ) ) ).

thf(thm_2Einteger_2EINT__SUB__LNEG,axiom,
    ! [V0x: tyop_2Einteger_2Eint,V1y: tyop_2Einteger_2Eint] :
      ( ( c_2Einteger_2Eint__sub @ ( c_2Einteger_2Eint__neg @ V0x ) @ V1y )
      = ( c_2Einteger_2Eint__neg @ ( c_2Einteger_2Eint__add @ V0x @ V1y ) ) ) ).

thf(thm_2Einteger_2EINT__SUB__RNEG,axiom,
    ! [V0x: tyop_2Einteger_2Eint,V1y: tyop_2Einteger_2Eint] :
      ( ( c_2Einteger_2Eint__sub @ V0x @ ( c_2Einteger_2Eint__neg @ V1y ) )
      = ( c_2Einteger_2Eint__add @ V0x @ V1y ) ) ).

thf(thm_2Einteger_2EINT__SUB__NEG2,axiom,
    ! [V0x: tyop_2Einteger_2Eint,V1y: tyop_2Einteger_2Eint] :
      ( ( c_2Einteger_2Eint__sub @ ( c_2Einteger_2Eint__neg @ V0x ) @ ( c_2Einteger_2Eint__neg @ V1y ) )
      = ( c_2Einteger_2Eint__sub @ V1y @ V0x ) ) ).

thf(thm_2Einteger_2EINT__SUB__TRIANGLE,axiom,
    ! [V0a: tyop_2Einteger_2Eint,V1b: tyop_2Einteger_2Eint,V2c: tyop_2Einteger_2Eint] :
      ( ( c_2Einteger_2Eint__add @ ( c_2Einteger_2Eint__sub @ V0a @ V1b ) @ ( c_2Einteger_2Eint__sub @ V1b @ V2c ) )
      = ( c_2Einteger_2Eint__sub @ V0a @ V2c ) ) ).

thf(thm_2Einteger_2EINT__EQ__SUB__LADD,axiom,
    ! [V0x: tyop_2Einteger_2Eint,V1y: tyop_2Einteger_2Eint,V2z: tyop_2Einteger_2Eint] :
      ( ( V0x
        = ( c_2Einteger_2Eint__sub @ V1y @ V2z ) )
    <=> ( ( c_2Einteger_2Eint__add @ V0x @ V2z )
        = V1y ) ) ).

thf(thm_2Einteger_2EINT__EQ__SUB__RADD,axiom,
    ! [V0x: tyop_2Einteger_2Eint,V1y: tyop_2Einteger_2Eint,V2z: tyop_2Einteger_2Eint] :
      ( ( ( c_2Einteger_2Eint__sub @ V0x @ V1y )
        = V2z )
    <=> ( V0x
        = ( c_2Einteger_2Eint__add @ V2z @ V1y ) ) ) ).

thf(thm_2Einteger_2EINT__SUB,axiom,
    ! [V0n: tyop_2Enum_2Enum,V1m: tyop_2Enum_2Enum] :
      ( ( c_2Earithmetic_2E_3C_3D @ V1m @ V0n )
     => ( ( c_2Einteger_2Eint__sub @ ( c_2Einteger_2Eint__of__num @ V0n ) @ ( c_2Einteger_2Eint__of__num @ V1m ) )
        = ( c_2Einteger_2Eint__of__num @ ( c_2Earithmetic_2E_2D @ V0n @ V1m ) ) ) ) ).

thf(thm_2Einteger_2EINT__SUB__SUB2,axiom,
    ! [V0x: tyop_2Einteger_2Eint,V1y: tyop_2Einteger_2Eint] :
      ( ( c_2Einteger_2Eint__sub @ V0x @ ( c_2Einteger_2Eint__sub @ V0x @ V1y ) )
      = V1y ) ).

thf(thm_2Einteger_2EINT__ADD__SUB2,axiom,
    ! [V0x: tyop_2Einteger_2Eint,V1y: tyop_2Einteger_2Eint] :
      ( ( c_2Einteger_2Eint__sub @ V0x @ ( c_2Einteger_2Eint__add @ V0x @ V1y ) )
      = ( c_2Einteger_2Eint__neg @ V1y ) ) ).

thf(thm_2Einteger_2EINT__EQ__LMUL2,axiom,
    ! [V0x: tyop_2Einteger_2Eint,V1y: tyop_2Einteger_2Eint,V2z: tyop_2Einteger_2Eint] :
      ( ( (~)
        @ ( V0x
          = ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) ) )
     => ( ( V1y = V2z )
      <=> ( ( c_2Einteger_2Eint__mul @ V0x @ V1y )
          = ( c_2Einteger_2Eint__mul @ V0x @ V2z ) ) ) ) ).

thf(thm_2Einteger_2EINT__EQ__IMP__LE,axiom,
    ! [V0x: tyop_2Einteger_2Eint,V1y: tyop_2Einteger_2Eint] :
      ( ( V0x = V1y )
     => ( c_2Einteger_2Eint__le @ V0x @ V1y ) ) ).

thf(thm_2Einteger_2EINT__POS__NZ,axiom,
    ! [V0x: tyop_2Einteger_2Eint] :
      ( ( c_2Einteger_2Eint__lt @ ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) @ V0x )
     => ( (~)
        @ ( V0x
          = ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) ) ) ) ).

thf(thm_2Einteger_2EINT__EQ__RMUL__IMP,axiom,
    ! [V0x: tyop_2Einteger_2Eint,V1y: tyop_2Einteger_2Eint,V2z: tyop_2Einteger_2Eint] :
      ( ( ( (~)
          @ ( V2z
            = ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) ) )
        & ( ( c_2Einteger_2Eint__mul @ V0x @ V2z )
          = ( c_2Einteger_2Eint__mul @ V1y @ V2z ) ) )
     => ( V0x = V1y ) ) ).

thf(thm_2Einteger_2EINT__EQ__LMUL__IMP,axiom,
    ! [V0x: tyop_2Einteger_2Eint,V1y: tyop_2Einteger_2Eint,V2z: tyop_2Einteger_2Eint] :
      ( ( ( (~)
          @ ( V0x
            = ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) ) )
        & ( ( c_2Einteger_2Eint__mul @ V0x @ V1y )
          = ( c_2Einteger_2Eint__mul @ V0x @ V2z ) ) )
     => ( V1y = V2z ) ) ).

thf(thm_2Einteger_2EINT__DIFFSQ,axiom,
    ! [V0x: tyop_2Einteger_2Eint,V1y: tyop_2Einteger_2Eint] :
      ( ( c_2Einteger_2Eint__mul @ ( c_2Einteger_2Eint__add @ V0x @ V1y ) @ ( c_2Einteger_2Eint__sub @ V0x @ V1y ) )
      = ( c_2Einteger_2Eint__sub @ ( c_2Einteger_2Eint__mul @ V0x @ V0x ) @ ( c_2Einteger_2Eint__mul @ V1y @ V1y ) ) ) ).

thf(thm_2Einteger_2EINT__POASQ,axiom,
    ! [V0x: tyop_2Einteger_2Eint] :
      ( ( c_2Einteger_2Eint__lt @ ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) @ ( c_2Einteger_2Eint__mul @ V0x @ V0x ) )
    <=> ( (~)
        @ ( V0x
          = ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) ) ) ) ).

thf(thm_2Einteger_2EINT__SUMSQ,axiom,
    ! [V0x: tyop_2Einteger_2Eint,V1y: tyop_2Einteger_2Eint] :
      ( ( ( c_2Einteger_2Eint__add @ ( c_2Einteger_2Eint__mul @ V0x @ V0x ) @ ( c_2Einteger_2Eint__mul @ V1y @ V1y ) )
        = ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) )
    <=> ( ( V0x
          = ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) )
        & ( V1y
          = ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) ) ) ) ).

thf(thm_2Einteger_2EINT__EQ__NEG,axiom,
    ! [V0x: tyop_2Einteger_2Eint,V1y: tyop_2Einteger_2Eint] :
      ( ( ( c_2Einteger_2Eint__neg @ V0x )
        = ( c_2Einteger_2Eint__neg @ V1y ) )
    <=> ( V0x = V1y ) ) ).

thf(thm_2Einteger_2EINT__LT__CALCULATE,axiom,
    ! [V0n: tyop_2Enum_2Enum,V1m: tyop_2Enum_2Enum] :
      ( ( ( c_2Einteger_2Eint__lt @ ( c_2Einteger_2Eint__of__num @ V0n ) @ ( c_2Einteger_2Eint__of__num @ V1m ) )
        = ( c_2Eprim__rec_2E_3C @ V0n @ V1m ) )
      & ( ( c_2Einteger_2Eint__lt @ ( c_2Einteger_2Eint__neg @ ( c_2Einteger_2Eint__of__num @ V0n ) ) @ ( c_2Einteger_2Eint__neg @ ( c_2Einteger_2Eint__of__num @ V1m ) ) )
        = ( c_2Eprim__rec_2E_3C @ V1m @ V0n ) )
      & ( ( c_2Einteger_2Eint__lt @ ( c_2Einteger_2Eint__neg @ ( c_2Einteger_2Eint__of__num @ V0n ) ) @ ( c_2Einteger_2Eint__of__num @ V1m ) )
      <=> ( ( (~) @ ( V0n = c_2Enum_2E0 ) )
          | ( (~) @ ( V1m = c_2Enum_2E0 ) ) ) )
      & ( ( c_2Einteger_2Eint__lt @ ( c_2Einteger_2Eint__of__num @ V0n ) @ ( c_2Einteger_2Eint__neg @ ( c_2Einteger_2Eint__of__num @ V1m ) ) )
        = c_2Ebool_2EF ) ) ).

thf(thm_2Einteger_2ENUM__POSINT,axiom,
    ! [V0i: tyop_2Einteger_2Eint] :
      ( ( c_2Einteger_2Eint__le @ ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) @ V0i )
     => ( c_2Ebool_2E_3F_21 @ tyop_2Enum_2Enum
        @ ^ [V1n: tyop_2Enum_2Enum] : ( c_2Emin_2E_3D @ tyop_2Einteger_2Eint @ V0i @ ( c_2Einteger_2Eint__of__num @ V1n ) ) ) ) ).

thf(thm_2Einteger_2ENUM__POSINT__EXISTS,axiom,
    ! [V0i: tyop_2Einteger_2Eint] :
      ( ( c_2Einteger_2Eint__le @ ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) @ V0i )
     => ? [V1n: tyop_2Enum_2Enum] :
          ( V0i
          = ( c_2Einteger_2Eint__of__num @ V1n ) ) ) ).

thf(thm_2Einteger_2ENUM__NEGINT__EXISTS,axiom,
    ! [V0i: tyop_2Einteger_2Eint] :
      ( ( c_2Einteger_2Eint__le @ V0i @ ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) )
     => ? [V1n: tyop_2Enum_2Enum] :
          ( V0i
          = ( c_2Einteger_2Eint__neg @ ( c_2Einteger_2Eint__of__num @ V1n ) ) ) ) ).

thf(thm_2Einteger_2EINT__NUM__CASES,axiom,
    ! [V0p: tyop_2Einteger_2Eint] :
      ( ? [V1n: tyop_2Enum_2Enum] :
          ( ( V0p
            = ( c_2Einteger_2Eint__of__num @ V1n ) )
          & ( (~) @ ( V1n = c_2Enum_2E0 ) ) )
      | ? [V2n: tyop_2Enum_2Enum] :
          ( ( V0p
            = ( c_2Einteger_2Eint__neg @ ( c_2Einteger_2Eint__of__num @ V2n ) ) )
          & ( (~) @ ( V2n = c_2Enum_2E0 ) ) )
      | ( V0p
        = ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) ) ) ).

thf(thm_2Einteger_2EINT__DISCRETE,axiom,
    ! [V0x: tyop_2Einteger_2Eint,V1y: tyop_2Einteger_2Eint] :
      ( (~)
      @ ( ( c_2Einteger_2Eint__lt @ V0x @ V1y )
        & ( c_2Einteger_2Eint__lt @ V1y @ ( c_2Einteger_2Eint__add @ V0x @ ( c_2Einteger_2Eint__of__num @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) ) ) ) ) ).

thf(thm_2Einteger_2EINT__LE__LT1,axiom,
    ! [V0y: tyop_2Einteger_2Eint,V1x: tyop_2Einteger_2Eint] :
      ( ( c_2Einteger_2Eint__le @ V1x @ V0y )
      = ( c_2Einteger_2Eint__lt @ V1x @ ( c_2Einteger_2Eint__add @ V0y @ ( c_2Einteger_2Eint__of__num @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) ) ) ) ).

thf(thm_2Einteger_2EINT__LT__LE1,axiom,
    ! [V0y: tyop_2Einteger_2Eint,V1x: tyop_2Einteger_2Eint] :
      ( ( c_2Einteger_2Eint__lt @ V1x @ V0y )
      = ( c_2Einteger_2Eint__le @ ( c_2Einteger_2Eint__add @ V1x @ ( c_2Einteger_2Eint__of__num @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) ) @ V0y ) ) ).

thf(thm_2Einteger_2EINT__MUL__EQ__1,axiom,
    ! [V0x: tyop_2Einteger_2Eint,V1y: tyop_2Einteger_2Eint] :
      ( ( ( c_2Einteger_2Eint__mul @ V0x @ V1y )
        = ( c_2Einteger_2Eint__of__num @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) )
    <=> ( ( ( V0x
            = ( c_2Einteger_2Eint__of__num @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) )
          & ( V1y
            = ( c_2Einteger_2Eint__of__num @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) ) )
        | ( ( V0x
            = ( c_2Einteger_2Eint__neg @ ( c_2Einteger_2Eint__of__num @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) ) )
          & ( V1y
            = ( c_2Einteger_2Eint__neg @ ( c_2Einteger_2Eint__of__num @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) ) ) ) ) ) ).

thf(thm_2Einteger_2ENUM__OF__INT,axiom,
    ! [V0n: tyop_2Enum_2Enum] :
      ( ( c_2Einteger_2ENum @ ( c_2Einteger_2Eint__of__num @ V0n ) )
      = V0n ) ).

thf(thm_2Einteger_2EINT__OF__NUM,axiom,
    ! [V0i: tyop_2Einteger_2Eint] :
      ( ( ( c_2Einteger_2Eint__of__num @ ( c_2Einteger_2ENum @ V0i ) )
        = V0i )
    <=> ( c_2Einteger_2Eint__le @ ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) @ V0i ) ) ).

thf(thm_2Einteger_2ELE__NUM__OF__INT,axiom,
    ! [V0n: tyop_2Enum_2Enum,V1i: tyop_2Einteger_2Eint] :
      ( ( c_2Einteger_2Eint__le @ ( c_2Einteger_2Eint__of__num @ V0n ) @ V1i )
     => ( c_2Earithmetic_2E_3C_3D @ V0n @ ( c_2Einteger_2ENum @ V1i ) ) ) ).

thf(thm_2Einteger_2ENUM__LT,axiom,
    ! [V0y: tyop_2Einteger_2Eint,V1x: tyop_2Einteger_2Eint] :
      ( ( ( c_2Einteger_2Eint__le @ ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) @ V1x )
        & ( c_2Einteger_2Eint__le @ ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) @ V0y ) )
     => ( ( c_2Eprim__rec_2E_3C @ ( c_2Einteger_2ENum @ V1x ) @ ( c_2Einteger_2ENum @ V0y ) )
        = ( c_2Einteger_2Eint__lt @ V1x @ V0y ) ) ) ).

thf(thm_2Einteger_2EINT__DIV,axiom,
    ! [V0n: tyop_2Enum_2Enum,V1m: tyop_2Enum_2Enum] :
      ( ( (~) @ ( V1m = c_2Enum_2E0 ) )
     => ( ( c_2Einteger_2Eint__div @ ( c_2Einteger_2Eint__of__num @ V0n ) @ ( c_2Einteger_2Eint__of__num @ V1m ) )
        = ( c_2Einteger_2Eint__of__num @ ( c_2Earithmetic_2EDIV @ V0n @ V1m ) ) ) ) ).

thf(thm_2Einteger_2EINT__DIV__NEG,axiom,
    ! [V0p: tyop_2Einteger_2Eint,V1q: tyop_2Einteger_2Eint] :
      ( ( (~)
        @ ( V1q
          = ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) ) )
     => ( ( c_2Einteger_2Eint__div @ V0p @ ( c_2Einteger_2Eint__neg @ V1q ) )
        = ( c_2Einteger_2Eint__div @ ( c_2Einteger_2Eint__neg @ V0p ) @ V1q ) ) ) ).

thf(thm_2Einteger_2EINT__DIV__1,axiom,
    ! [V0p: tyop_2Einteger_2Eint] :
      ( ( c_2Einteger_2Eint__div @ V0p @ ( c_2Einteger_2Eint__of__num @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) )
      = V0p ) ).

thf(thm_2Einteger_2EINT__DIV__0,axiom,
    ! [V0q: tyop_2Einteger_2Eint] :
      ( ( (~)
        @ ( V0q
          = ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) ) )
     => ( ( c_2Einteger_2Eint__div @ ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) @ V0q )
        = ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) ) ) ).

thf(thm_2Einteger_2EINT__DIV__ID,axiom,
    ! [V0p: tyop_2Einteger_2Eint] :
      ( ( (~)
        @ ( V0p
          = ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) ) )
     => ( ( c_2Einteger_2Eint__div @ V0p @ V0p )
        = ( c_2Einteger_2Eint__of__num @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) ) ) ).

thf(thm_2Einteger_2EINT__MOD__BOUNDS,axiom,
    ! [V0p: tyop_2Einteger_2Eint,V1q: tyop_2Einteger_2Eint] :
      ( ( (~)
        @ ( V1q
          = ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) ) )
     => ( c_2Ebool_2ECOND @ $o @ ( c_2Einteger_2Eint__lt @ V1q @ ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) ) @ ( c_2Ebool_2E_2F_5C @ ( c_2Einteger_2Eint__lt @ V1q @ ( c_2Einteger_2Eint__mod @ V0p @ V1q ) ) @ ( c_2Einteger_2Eint__le @ ( c_2Einteger_2Eint__mod @ V0p @ V1q ) @ ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) ) ) @ ( c_2Ebool_2E_2F_5C @ ( c_2Einteger_2Eint__le @ ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) @ ( c_2Einteger_2Eint__mod @ V0p @ V1q ) ) @ ( c_2Einteger_2Eint__lt @ ( c_2Einteger_2Eint__mod @ V0p @ V1q ) @ V1q ) ) ) ) ).

thf(thm_2Einteger_2EINT__DIVISION,axiom,
    ! [V0q: tyop_2Einteger_2Eint] :
      ( ( (~)
        @ ( V0q
          = ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) ) )
     => ! [V1p: tyop_2Einteger_2Eint] :
          ( ( V1p
            = ( c_2Einteger_2Eint__add @ ( c_2Einteger_2Eint__mul @ ( c_2Einteger_2Eint__div @ V1p @ V0q ) @ V0q ) @ ( c_2Einteger_2Eint__mod @ V1p @ V0q ) ) )
          & ( c_2Ebool_2ECOND @ $o @ ( c_2Einteger_2Eint__lt @ V0q @ ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) ) @ ( c_2Ebool_2E_2F_5C @ ( c_2Einteger_2Eint__lt @ V0q @ ( c_2Einteger_2Eint__mod @ V1p @ V0q ) ) @ ( c_2Einteger_2Eint__le @ ( c_2Einteger_2Eint__mod @ V1p @ V0q ) @ ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) ) ) @ ( c_2Ebool_2E_2F_5C @ ( c_2Einteger_2Eint__le @ ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) @ ( c_2Einteger_2Eint__mod @ V1p @ V0q ) ) @ ( c_2Einteger_2Eint__lt @ ( c_2Einteger_2Eint__mod @ V1p @ V0q ) @ V0q ) ) ) ) ) ).

thf(thm_2Einteger_2EINT__MOD,axiom,
    ! [V0n: tyop_2Enum_2Enum,V1m: tyop_2Enum_2Enum] :
      ( ( (~) @ ( V1m = c_2Enum_2E0 ) )
     => ( ( c_2Einteger_2Eint__mod @ ( c_2Einteger_2Eint__of__num @ V0n ) @ ( c_2Einteger_2Eint__of__num @ V1m ) )
        = ( c_2Einteger_2Eint__of__num @ ( c_2Earithmetic_2EMOD @ V0n @ V1m ) ) ) ) ).

thf(thm_2Einteger_2EINT__MOD__NEG,axiom,
    ! [V0p: tyop_2Einteger_2Eint,V1q: tyop_2Einteger_2Eint] :
      ( ( (~)
        @ ( V1q
          = ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) ) )
     => ( ( c_2Einteger_2Eint__mod @ V0p @ ( c_2Einteger_2Eint__neg @ V1q ) )
        = ( c_2Einteger_2Eint__neg @ ( c_2Einteger_2Eint__mod @ ( c_2Einteger_2Eint__neg @ V0p ) @ V1q ) ) ) ) ).

thf(thm_2Einteger_2EINT__MOD0,axiom,
    ! [V0p: tyop_2Einteger_2Eint] :
      ( ( (~)
        @ ( V0p
          = ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) ) )
     => ( ( c_2Einteger_2Eint__mod @ ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) @ V0p )
        = ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) ) ) ).

thf(thm_2Einteger_2EINT__DIV__MUL__ID,axiom,
    ! [V0p: tyop_2Einteger_2Eint,V1q: tyop_2Einteger_2Eint] :
      ( ( ( (~)
          @ ( V1q
            = ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) ) )
        & ( ( c_2Einteger_2Eint__mod @ V0p @ V1q )
          = ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) ) )
     => ( ( c_2Einteger_2Eint__mul @ ( c_2Einteger_2Eint__div @ V0p @ V1q ) @ V1q )
        = V0p ) ) ).

thf(thm_2Einteger_2EINT__DIV__UNIQUE,axiom,
    ! [V0i: tyop_2Einteger_2Eint,V1j: tyop_2Einteger_2Eint,V2q: tyop_2Einteger_2Eint] :
      ( ? [V3r: tyop_2Einteger_2Eint] :
          ( ( V0i
            = ( c_2Einteger_2Eint__add @ ( c_2Einteger_2Eint__mul @ V2q @ V1j ) @ V3r ) )
          & ( c_2Ebool_2ECOND @ $o @ ( c_2Einteger_2Eint__lt @ V1j @ ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) ) @ ( c_2Ebool_2E_2F_5C @ ( c_2Einteger_2Eint__lt @ V1j @ V3r ) @ ( c_2Einteger_2Eint__le @ V3r @ ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) ) ) @ ( c_2Ebool_2E_2F_5C @ ( c_2Einteger_2Eint__le @ ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) @ V3r ) @ ( c_2Einteger_2Eint__lt @ V3r @ V1j ) ) ) )
     => ( ( c_2Einteger_2Eint__div @ V0i @ V1j )
        = V2q ) ) ).

thf(thm_2Einteger_2EINT__MOD__UNIQUE,axiom,
    ! [V0i: tyop_2Einteger_2Eint,V1j: tyop_2Einteger_2Eint,V2m: tyop_2Einteger_2Eint] :
      ( ? [V3q: tyop_2Einteger_2Eint] :
          ( ( V0i
            = ( c_2Einteger_2Eint__add @ ( c_2Einteger_2Eint__mul @ V3q @ V1j ) @ V2m ) )
          & ( c_2Ebool_2ECOND @ $o @ ( c_2Einteger_2Eint__lt @ V1j @ ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) ) @ ( c_2Ebool_2E_2F_5C @ ( c_2Einteger_2Eint__lt @ V1j @ V2m ) @ ( c_2Einteger_2Eint__le @ V2m @ ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) ) ) @ ( c_2Ebool_2E_2F_5C @ ( c_2Einteger_2Eint__le @ ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) @ V2m ) @ ( c_2Einteger_2Eint__lt @ V2m @ V1j ) ) ) )
     => ( ( c_2Einteger_2Eint__mod @ V0i @ V1j )
        = V2m ) ) ).

thf(thm_2Einteger_2EINT__MOD__ID,axiom,
    ! [V0i: tyop_2Einteger_2Eint] :
      ( ( (~)
        @ ( V0i
          = ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) ) )
     => ( ( c_2Einteger_2Eint__mod @ V0i @ V0i )
        = ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) ) ) ).

thf(thm_2Einteger_2EINT__MOD__COMMON__FACTOR,axiom,
    ! [V0p: tyop_2Einteger_2Eint] :
      ( ( (~)
        @ ( V0p
          = ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) ) )
     => ! [V1q: tyop_2Einteger_2Eint] :
          ( ( c_2Einteger_2Eint__mod @ ( c_2Einteger_2Eint__mul @ V1q @ V0p ) @ V0p )
          = ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) ) ) ).

thf(thm_2Einteger_2EINT__DIV__LMUL,axiom,
    ! [V0i: tyop_2Einteger_2Eint,V1j: tyop_2Einteger_2Eint] :
      ( ( (~)
        @ ( V0i
          = ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) ) )
     => ( ( c_2Einteger_2Eint__div @ ( c_2Einteger_2Eint__mul @ V0i @ V1j ) @ V0i )
        = V1j ) ) ).

thf(thm_2Einteger_2EINT__DIV__RMUL,axiom,
    ! [V0i: tyop_2Einteger_2Eint,V1j: tyop_2Einteger_2Eint] :
      ( ( (~)
        @ ( V0i
          = ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) ) )
     => ( ( c_2Einteger_2Eint__div @ ( c_2Einteger_2Eint__mul @ V1j @ V0i ) @ V0i )
        = V1j ) ) ).

thf(thm_2Einteger_2EINT__MOD__EQ0,axiom,
    ! [V0q: tyop_2Einteger_2Eint] :
      ( ( (~)
        @ ( V0q
          = ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) ) )
     => ! [V1p: tyop_2Einteger_2Eint] :
          ( ( ( c_2Einteger_2Eint__mod @ V1p @ V0q )
            = ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) )
        <=> ? [V2k: tyop_2Einteger_2Eint] :
              ( V1p
              = ( c_2Einteger_2Eint__mul @ V2k @ V0q ) ) ) ) ).

thf(thm_2Einteger_2EINT__MUL__DIV,axiom,
    ! [V0p: tyop_2Einteger_2Eint,V1q: tyop_2Einteger_2Eint,V2k: tyop_2Einteger_2Eint] :
      ( ( ( (~)
          @ ( V1q
            = ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) ) )
        & ( ( c_2Einteger_2Eint__mod @ V0p @ V1q )
          = ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) ) )
     => ( ( c_2Einteger_2Eint__div @ ( c_2Einteger_2Eint__mul @ V2k @ V0p ) @ V1q )
        = ( c_2Einteger_2Eint__mul @ V2k @ ( c_2Einteger_2Eint__div @ V0p @ V1q ) ) ) ) ).

thf(thm_2Einteger_2EINT__ADD__DIV,axiom,
    ! [V0i: tyop_2Einteger_2Eint,V1j: tyop_2Einteger_2Eint,V2k: tyop_2Einteger_2Eint] :
      ( ( ( (~)
          @ ( V2k
            = ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) ) )
        & ( ( ( c_2Einteger_2Eint__mod @ V0i @ V2k )
            = ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) )
          | ( ( c_2Einteger_2Eint__mod @ V1j @ V2k )
            = ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) ) ) )
     => ( ( c_2Einteger_2Eint__div @ ( c_2Einteger_2Eint__add @ V0i @ V1j ) @ V2k )
        = ( c_2Einteger_2Eint__add @ ( c_2Einteger_2Eint__div @ V0i @ V2k ) @ ( c_2Einteger_2Eint__div @ V1j @ V2k ) ) ) ) ).

thf(thm_2Einteger_2EINT__MOD__ADD__MULTIPLES,axiom,
    ! [V0r: tyop_2Einteger_2Eint,V1q: tyop_2Einteger_2Eint,V2k: tyop_2Einteger_2Eint] :
      ( ( (~)
        @ ( V2k
          = ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) ) )
     => ( ( c_2Einteger_2Eint__mod @ ( c_2Einteger_2Eint__add @ ( c_2Einteger_2Eint__mul @ V1q @ V2k ) @ V0r ) @ V2k )
        = ( c_2Einteger_2Eint__mod @ V0r @ V2k ) ) ) ).

thf(thm_2Einteger_2EINT__MOD__NEG__NUMERATOR,axiom,
    ! [V0x: tyop_2Einteger_2Eint,V1k: tyop_2Einteger_2Eint] :
      ( ( (~)
        @ ( V1k
          = ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) ) )
     => ( ( c_2Einteger_2Eint__mod @ ( c_2Einteger_2Eint__neg @ V0x ) @ V1k )
        = ( c_2Einteger_2Eint__mod @ ( c_2Einteger_2Eint__sub @ V1k @ V0x ) @ V1k ) ) ) ).

thf(thm_2Einteger_2EINT__MOD__PLUS,axiom,
    ! [V0k: tyop_2Einteger_2Eint,V1j: tyop_2Einteger_2Eint,V2i: tyop_2Einteger_2Eint] :
      ( ( (~)
        @ ( V0k
          = ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) ) )
     => ( ( c_2Einteger_2Eint__mod @ ( c_2Einteger_2Eint__add @ ( c_2Einteger_2Eint__mod @ V2i @ V0k ) @ ( c_2Einteger_2Eint__mod @ V1j @ V0k ) ) @ V0k )
        = ( c_2Einteger_2Eint__mod @ ( c_2Einteger_2Eint__add @ V2i @ V1j ) @ V0k ) ) ) ).

thf(thm_2Einteger_2EINT__MOD__SUB,axiom,
    ! [V0k: tyop_2Einteger_2Eint,V1j: tyop_2Einteger_2Eint,V2i: tyop_2Einteger_2Eint] :
      ( ( (~)
        @ ( V0k
          = ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) ) )
     => ( ( c_2Einteger_2Eint__mod @ ( c_2Einteger_2Eint__sub @ ( c_2Einteger_2Eint__mod @ V2i @ V0k ) @ ( c_2Einteger_2Eint__mod @ V1j @ V0k ) ) @ V0k )
        = ( c_2Einteger_2Eint__mod @ ( c_2Einteger_2Eint__sub @ V2i @ V1j ) @ V0k ) ) ) ).

thf(thm_2Einteger_2EINT__MOD__MOD,axiom,
    ! [V0k: tyop_2Einteger_2Eint,V1j: tyop_2Einteger_2Eint] :
      ( ( (~)
        @ ( V0k
          = ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) ) )
     => ( ( c_2Einteger_2Eint__mod @ ( c_2Einteger_2Eint__mod @ V1j @ V0k ) @ V0k )
        = ( c_2Einteger_2Eint__mod @ V1j @ V0k ) ) ) ).

thf(thm_2Einteger_2EINT__DIV__P,axiom,
    ! [V0P: tyop_2Einteger_2Eint > $o,V1x: tyop_2Einteger_2Eint,V2c: tyop_2Einteger_2Eint] :
      ( ( (~)
        @ ( V2c
          = ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) ) )
     => ( ( V0P @ ( c_2Einteger_2Eint__div @ V1x @ V2c ) )
      <=> ? [V3k: tyop_2Einteger_2Eint,V4r: tyop_2Einteger_2Eint] :
            ( ( V1x
              = ( c_2Einteger_2Eint__add @ ( c_2Einteger_2Eint__mul @ V3k @ V2c ) @ V4r ) )
            & ( ( ( c_2Einteger_2Eint__lt @ V2c @ ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) )
                & ( c_2Einteger_2Eint__lt @ V2c @ V4r )
                & ( c_2Einteger_2Eint__le @ V4r @ ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) ) )
              | ( ( (~) @ ( c_2Einteger_2Eint__lt @ V2c @ ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) ) )
                & ( c_2Einteger_2Eint__le @ ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) @ V4r )
                & ( c_2Einteger_2Eint__lt @ V4r @ V2c ) ) )
            & ( V0P @ V3k ) ) ) ) ).

thf(thm_2Einteger_2EINT__MOD__P,axiom,
    ! [V0P: tyop_2Einteger_2Eint > $o,V1x: tyop_2Einteger_2Eint,V2c: tyop_2Einteger_2Eint] :
      ( ( (~)
        @ ( V2c
          = ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) ) )
     => ( ( V0P @ ( c_2Einteger_2Eint__mod @ V1x @ V2c ) )
      <=> ? [V3k: tyop_2Einteger_2Eint,V4r: tyop_2Einteger_2Eint] :
            ( ( V1x
              = ( c_2Einteger_2Eint__add @ ( c_2Einteger_2Eint__mul @ V3k @ V2c ) @ V4r ) )
            & ( ( ( c_2Einteger_2Eint__lt @ V2c @ ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) )
                & ( c_2Einteger_2Eint__lt @ V2c @ V4r )
                & ( c_2Einteger_2Eint__le @ V4r @ ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) ) )
              | ( ( (~) @ ( c_2Einteger_2Eint__lt @ V2c @ ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) ) )
                & ( c_2Einteger_2Eint__le @ ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) @ V4r )
                & ( c_2Einteger_2Eint__lt @ V4r @ V2c ) ) )
            & ( V0P @ V4r ) ) ) ) ).

thf(thm_2Einteger_2EINT__DIV__FORALL__P,axiom,
    ! [V0P: tyop_2Einteger_2Eint > $o,V1x: tyop_2Einteger_2Eint,V2c: tyop_2Einteger_2Eint] :
      ( ( (~)
        @ ( V2c
          = ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) ) )
     => ( ( V0P @ ( c_2Einteger_2Eint__div @ V1x @ V2c ) )
      <=> ! [V3k: tyop_2Einteger_2Eint,V4r: tyop_2Einteger_2Eint] :
            ( ( ( V1x
                = ( c_2Einteger_2Eint__add @ ( c_2Einteger_2Eint__mul @ V3k @ V2c ) @ V4r ) )
              & ( ( ( c_2Einteger_2Eint__lt @ V2c @ ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) )
                  & ( c_2Einteger_2Eint__lt @ V2c @ V4r )
                  & ( c_2Einteger_2Eint__le @ V4r @ ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) ) )
                | ( ( (~) @ ( c_2Einteger_2Eint__lt @ V2c @ ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) ) )
                  & ( c_2Einteger_2Eint__le @ ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) @ V4r )
                  & ( c_2Einteger_2Eint__lt @ V4r @ V2c ) ) ) )
           => ( V0P @ V3k ) ) ) ) ).

thf(thm_2Einteger_2EINT__MOD__FORALL__P,axiom,
    ! [V0P: tyop_2Einteger_2Eint > $o,V1x: tyop_2Einteger_2Eint,V2c: tyop_2Einteger_2Eint] :
      ( ( (~)
        @ ( V2c
          = ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) ) )
     => ( ( V0P @ ( c_2Einteger_2Eint__mod @ V1x @ V2c ) )
      <=> ! [V3q: tyop_2Einteger_2Eint,V4r: tyop_2Einteger_2Eint] :
            ( ( ( V1x
                = ( c_2Einteger_2Eint__add @ ( c_2Einteger_2Eint__mul @ V3q @ V2c ) @ V4r ) )
              & ( ( ( c_2Einteger_2Eint__lt @ V2c @ ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) )
                  & ( c_2Einteger_2Eint__lt @ V2c @ V4r )
                  & ( c_2Einteger_2Eint__le @ V4r @ ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) ) )
                | ( ( (~) @ ( c_2Einteger_2Eint__lt @ V2c @ ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) ) )
                  & ( c_2Einteger_2Eint__le @ ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) @ V4r )
                  & ( c_2Einteger_2Eint__lt @ V4r @ V2c ) ) ) )
           => ( V0P @ V4r ) ) ) ) ).

thf(thm_2Einteger_2EINT__MOD__1,axiom,
    ! [V0i: tyop_2Einteger_2Eint] :
      ( ( c_2Einteger_2Eint__mod @ V0i @ ( c_2Einteger_2Eint__of__num @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) )
      = ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) ) ).

thf(thm_2Einteger_2EINT__LESS__MOD,axiom,
    ! [V0i: tyop_2Einteger_2Eint,V1j: tyop_2Einteger_2Eint] :
      ( ( ( c_2Einteger_2Eint__le @ ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) @ V0i )
        & ( c_2Einteger_2Eint__lt @ V0i @ V1j ) )
     => ( ( c_2Einteger_2Eint__mod @ V0i @ V1j )
        = V0i ) ) ).

thf(thm_2Einteger_2EINT__MOD__MINUS1,axiom,
    ! [V0n: tyop_2Einteger_2Eint] :
      ( ( c_2Einteger_2Eint__lt @ ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) @ V0n )
     => ( ( c_2Einteger_2Eint__mod @ ( c_2Einteger_2Eint__neg @ ( c_2Einteger_2Eint__of__num @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) ) @ V0n )
        = ( c_2Einteger_2Eint__sub @ V0n @ ( c_2Einteger_2Eint__of__num @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) ) ) ) ).

thf(thm_2Einteger_2EINT__ABS__POS,axiom,
    ! [V0p: tyop_2Einteger_2Eint] : ( c_2Einteger_2Eint__le @ ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) @ ( c_2Einteger_2EABS @ V0p ) ) ).

thf(thm_2Einteger_2EINT__ABS__NUM,axiom,
    ! [V0n: tyop_2Enum_2Enum] :
      ( ( c_2Einteger_2EABS @ ( c_2Einteger_2Eint__of__num @ V0n ) )
      = ( c_2Einteger_2Eint__of__num @ V0n ) ) ).

thf(thm_2Einteger_2EINT__NEG__SAME__EQ,axiom,
    ! [V0p: tyop_2Einteger_2Eint] :
      ( ( V0p
        = ( c_2Einteger_2Eint__neg @ V0p ) )
    <=> ( V0p
        = ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) ) ) ).

thf(thm_2Einteger_2EINT__ABS__NEG,axiom,
    ! [V0p: tyop_2Einteger_2Eint] :
      ( ( c_2Einteger_2EABS @ ( c_2Einteger_2Eint__neg @ V0p ) )
      = ( c_2Einteger_2EABS @ V0p ) ) ).

thf(thm_2Einteger_2EINT__ABS__ABS,axiom,
    ! [V0p: tyop_2Einteger_2Eint] :
      ( ( c_2Einteger_2EABS @ ( c_2Einteger_2EABS @ V0p ) )
      = ( c_2Einteger_2EABS @ V0p ) ) ).

thf(thm_2Einteger_2EINT__ABS__EQ__ID,axiom,
    ! [V0p: tyop_2Einteger_2Eint] :
      ( ( ( c_2Einteger_2EABS @ V0p )
        = V0p )
    <=> ( c_2Einteger_2Eint__le @ ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) @ V0p ) ) ).

thf(thm_2Einteger_2EINT__ABS__MUL,axiom,
    ! [V0p: tyop_2Einteger_2Eint,V1q: tyop_2Einteger_2Eint] :
      ( ( c_2Einteger_2Eint__mul @ ( c_2Einteger_2EABS @ V0p ) @ ( c_2Einteger_2EABS @ V1q ) )
      = ( c_2Einteger_2EABS @ ( c_2Einteger_2Eint__mul @ V0p @ V1q ) ) ) ).

thf(thm_2Einteger_2EINT__ABS__EQ0,axiom,
    ! [V0p: tyop_2Einteger_2Eint] :
      ( ( ( c_2Einteger_2EABS @ V0p )
        = ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) )
    <=> ( V0p
        = ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) ) ) ).

thf(thm_2Einteger_2EINT__ABS__LT0,axiom,
    ! [V0p: tyop_2Einteger_2Eint] : ( (~) @ ( c_2Einteger_2Eint__lt @ ( c_2Einteger_2EABS @ V0p ) @ ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) ) ) ).

thf(thm_2Einteger_2EINT__ABS__0LT,axiom,
    ! [V0p: tyop_2Einteger_2Eint] :
      ( ( c_2Einteger_2Eint__lt @ ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) @ ( c_2Einteger_2EABS @ V0p ) )
    <=> ( (~)
        @ ( V0p
          = ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) ) ) ) ).

thf(thm_2Einteger_2EINT__ABS__LE0,axiom,
    ! [V0p: tyop_2Einteger_2Eint] :
      ( ( c_2Einteger_2Eint__le @ ( c_2Einteger_2EABS @ V0p ) @ ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) )
    <=> ( V0p
        = ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) ) ) ).

thf(thm_2Einteger_2EINT__ABS__LT,axiom,
    ! [V0p: tyop_2Einteger_2Eint,V1q: tyop_2Einteger_2Eint] :
      ( ( ( c_2Einteger_2Eint__lt @ ( c_2Einteger_2EABS @ V0p ) @ V1q )
      <=> ( ( c_2Einteger_2Eint__lt @ V0p @ V1q )
          & ( c_2Einteger_2Eint__lt @ ( c_2Einteger_2Eint__neg @ V1q ) @ V0p ) ) )
      & ( ( c_2Einteger_2Eint__lt @ V1q @ ( c_2Einteger_2EABS @ V0p ) )
      <=> ( ( c_2Einteger_2Eint__lt @ V1q @ V0p )
          | ( c_2Einteger_2Eint__lt @ V0p @ ( c_2Einteger_2Eint__neg @ V1q ) ) ) )
      & ( ( c_2Einteger_2Eint__lt @ ( c_2Einteger_2Eint__neg @ ( c_2Einteger_2EABS @ V0p ) ) @ V1q )
      <=> ( ( c_2Einteger_2Eint__lt @ ( c_2Einteger_2Eint__neg @ V1q ) @ V0p )
          | ( c_2Einteger_2Eint__lt @ V0p @ V1q ) ) )
      & ( ( c_2Einteger_2Eint__lt @ V1q @ ( c_2Einteger_2Eint__neg @ ( c_2Einteger_2EABS @ V0p ) ) )
      <=> ( ( c_2Einteger_2Eint__lt @ V0p @ ( c_2Einteger_2Eint__neg @ V1q ) )
          & ( c_2Einteger_2Eint__lt @ V1q @ V0p ) ) ) ) ).

thf(thm_2Einteger_2EINT__ABS__LE,axiom,
    ! [V0p: tyop_2Einteger_2Eint,V1q: tyop_2Einteger_2Eint] :
      ( ( ( c_2Einteger_2Eint__le @ ( c_2Einteger_2EABS @ V0p ) @ V1q )
      <=> ( ( c_2Einteger_2Eint__le @ V0p @ V1q )
          & ( c_2Einteger_2Eint__le @ ( c_2Einteger_2Eint__neg @ V1q ) @ V0p ) ) )
      & ( ( c_2Einteger_2Eint__le @ V1q @ ( c_2Einteger_2EABS @ V0p ) )
      <=> ( ( c_2Einteger_2Eint__le @ V1q @ V0p )
          | ( c_2Einteger_2Eint__le @ V0p @ ( c_2Einteger_2Eint__neg @ V1q ) ) ) )
      & ( ( c_2Einteger_2Eint__le @ ( c_2Einteger_2Eint__neg @ ( c_2Einteger_2EABS @ V0p ) ) @ V1q )
      <=> ( ( c_2Einteger_2Eint__le @ ( c_2Einteger_2Eint__neg @ V1q ) @ V0p )
          | ( c_2Einteger_2Eint__le @ V0p @ V1q ) ) )
      & ( ( c_2Einteger_2Eint__le @ V1q @ ( c_2Einteger_2Eint__neg @ ( c_2Einteger_2EABS @ V0p ) ) )
      <=> ( ( c_2Einteger_2Eint__le @ V0p @ ( c_2Einteger_2Eint__neg @ V1q ) )
          & ( c_2Einteger_2Eint__le @ V1q @ V0p ) ) ) ) ).

thf(thm_2Einteger_2EINT__ABS__EQ,axiom,
    ! [V0p: tyop_2Einteger_2Eint,V1q: tyop_2Einteger_2Eint] :
      ( ( ( ( c_2Einteger_2EABS @ V0p )
          = V1q )
      <=> ( ( ( V0p = V1q )
            & ( c_2Einteger_2Eint__lt @ ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) @ V1q ) )
          | ( ( V0p
              = ( c_2Einteger_2Eint__neg @ V1q ) )
            & ( c_2Einteger_2Eint__le @ ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) @ V1q ) ) ) )
      & ( ( V1q
          = ( c_2Einteger_2EABS @ V0p ) )
      <=> ( ( ( V0p = V1q )
            & ( c_2Einteger_2Eint__lt @ ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) @ V1q ) )
          | ( ( V0p
              = ( c_2Einteger_2Eint__neg @ V1q ) )
            & ( c_2Einteger_2Eint__le @ ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) @ V1q ) ) ) ) ) ).

thf(thm_2Einteger_2EINT__ABS__EQ__ABS,axiom,
    ! [V0y: tyop_2Einteger_2Eint,V1x: tyop_2Einteger_2Eint] :
      ( ( ( c_2Einteger_2EABS @ V1x )
        = ( c_2Einteger_2EABS @ V0y ) )
    <=> ( ( V1x = V0y )
        | ( V1x
          = ( c_2Einteger_2Eint__neg @ V0y ) ) ) ) ).

thf(thm_2Einteger_2EINT__QUOT,axiom,
    ! [V0p: tyop_2Enum_2Enum,V1q: tyop_2Enum_2Enum] :
      ( ( (~) @ ( V1q = c_2Enum_2E0 ) )
     => ( ( c_2Einteger_2Eint__quot @ ( c_2Einteger_2Eint__of__num @ V0p ) @ ( c_2Einteger_2Eint__of__num @ V1q ) )
        = ( c_2Einteger_2Eint__of__num @ ( c_2Earithmetic_2EDIV @ V0p @ V1q ) ) ) ) ).

thf(thm_2Einteger_2EINT__QUOT__0,axiom,
    ! [V0q: tyop_2Einteger_2Eint] :
      ( ( (~)
        @ ( V0q
          = ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) ) )
     => ( ( c_2Einteger_2Eint__quot @ ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) @ V0q )
        = ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) ) ) ).

thf(thm_2Einteger_2EINT__QUOT__1,axiom,
    ! [V0p: tyop_2Einteger_2Eint] :
      ( ( c_2Einteger_2Eint__quot @ V0p @ ( c_2Einteger_2Eint__of__num @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) )
      = V0p ) ).

thf(thm_2Einteger_2EINT__QUOT__NEG,axiom,
    ! [V0p: tyop_2Einteger_2Eint,V1q: tyop_2Einteger_2Eint] :
      ( ( (~)
        @ ( V1q
          = ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) ) )
     => ( ( ( c_2Einteger_2Eint__quot @ ( c_2Einteger_2Eint__neg @ V0p ) @ V1q )
          = ( c_2Einteger_2Eint__neg @ ( c_2Einteger_2Eint__quot @ V0p @ V1q ) ) )
        & ( ( c_2Einteger_2Eint__quot @ V0p @ ( c_2Einteger_2Eint__neg @ V1q ) )
          = ( c_2Einteger_2Eint__neg @ ( c_2Einteger_2Eint__quot @ V0p @ V1q ) ) ) ) ) ).

thf(thm_2Einteger_2EINT__ABS__QUOT,axiom,
    ! [V0p: tyop_2Einteger_2Eint,V1q: tyop_2Einteger_2Eint] :
      ( ( (~)
        @ ( V1q
          = ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) ) )
     => ( c_2Einteger_2Eint__le @ ( c_2Einteger_2EABS @ ( c_2Einteger_2Eint__mul @ ( c_2Einteger_2Eint__quot @ V0p @ V1q ) @ V1q ) ) @ ( c_2Einteger_2EABS @ V0p ) ) ) ).

thf(thm_2Einteger_2EINT__QUOT__UNIQUE,axiom,
    ! [V0p: tyop_2Einteger_2Eint,V1q: tyop_2Einteger_2Eint,V2k: tyop_2Einteger_2Eint] :
      ( ? [V3r: tyop_2Einteger_2Eint] :
          ( ( V0p
            = ( c_2Einteger_2Eint__add @ ( c_2Einteger_2Eint__mul @ V2k @ V1q ) @ V3r ) )
          & ( c_2Ebool_2ECOND @ $o @ ( c_2Einteger_2Eint__lt @ ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) @ V0p ) @ ( c_2Einteger_2Eint__le @ ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) @ V3r ) @ ( c_2Einteger_2Eint__le @ V3r @ ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) ) )
          & ( c_2Einteger_2Eint__lt @ ( c_2Einteger_2EABS @ V3r ) @ ( c_2Einteger_2EABS @ V1q ) ) )
     => ( ( c_2Einteger_2Eint__quot @ V0p @ V1q )
        = V2k ) ) ).

thf(thm_2Einteger_2EINT__QUOT__ID,axiom,
    ! [V0p: tyop_2Einteger_2Eint] :
      ( ( (~)
        @ ( V0p
          = ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) ) )
     => ( ( c_2Einteger_2Eint__quot @ V0p @ V0p )
        = ( c_2Einteger_2Eint__of__num @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) ) ) ).

thf(thm_2Einteger_2EINT__REM,axiom,
    ! [V0p: tyop_2Enum_2Enum,V1q: tyop_2Enum_2Enum] :
      ( ( (~) @ ( V1q = c_2Enum_2E0 ) )
     => ( ( c_2Einteger_2Eint__rem @ ( c_2Einteger_2Eint__of__num @ V0p ) @ ( c_2Einteger_2Eint__of__num @ V1q ) )
        = ( c_2Einteger_2Eint__of__num @ ( c_2Earithmetic_2EMOD @ V0p @ V1q ) ) ) ) ).

thf(thm_2Einteger_2EINT__REMQUOT,axiom,
    ! [V0q: tyop_2Einteger_2Eint] :
      ( ( (~)
        @ ( V0q
          = ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) ) )
     => ! [V1p: tyop_2Einteger_2Eint] :
          ( ( V1p
            = ( c_2Einteger_2Eint__add @ ( c_2Einteger_2Eint__mul @ ( c_2Einteger_2Eint__quot @ V1p @ V0q ) @ V0q ) @ ( c_2Einteger_2Eint__rem @ V1p @ V0q ) ) )
          & ( c_2Ebool_2ECOND @ $o @ ( c_2Einteger_2Eint__lt @ ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) @ V1p ) @ ( c_2Einteger_2Eint__le @ ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) @ ( c_2Einteger_2Eint__rem @ V1p @ V0q ) ) @ ( c_2Einteger_2Eint__le @ ( c_2Einteger_2Eint__rem @ V1p @ V0q ) @ ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) ) )
          & ( c_2Einteger_2Eint__lt @ ( c_2Einteger_2EABS @ ( c_2Einteger_2Eint__rem @ V1p @ V0q ) ) @ ( c_2Einteger_2EABS @ V0q ) ) ) ) ).

thf(thm_2Einteger_2EINT__REM__UNIQUE,axiom,
    ! [V0p: tyop_2Einteger_2Eint,V1q: tyop_2Einteger_2Eint,V2r: tyop_2Einteger_2Eint] :
      ( ( ( c_2Einteger_2Eint__lt @ ( c_2Einteger_2EABS @ V2r ) @ ( c_2Einteger_2EABS @ V1q ) )
        & ( c_2Ebool_2ECOND @ $o @ ( c_2Einteger_2Eint__lt @ ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) @ V0p ) @ ( c_2Einteger_2Eint__le @ ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) @ V2r ) @ ( c_2Einteger_2Eint__le @ V2r @ ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) ) )
        & ? [V3k: tyop_2Einteger_2Eint] :
            ( V0p
            = ( c_2Einteger_2Eint__add @ ( c_2Einteger_2Eint__mul @ V3k @ V1q ) @ V2r ) ) )
     => ( ( c_2Einteger_2Eint__rem @ V0p @ V1q )
        = V2r ) ) ).

thf(thm_2Einteger_2EINT__REM__NEG,axiom,
    ! [V0p: tyop_2Einteger_2Eint,V1q: tyop_2Einteger_2Eint] :
      ( ( (~)
        @ ( V1q
          = ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) ) )
     => ( ( ( c_2Einteger_2Eint__rem @ ( c_2Einteger_2Eint__neg @ V0p ) @ V1q )
          = ( c_2Einteger_2Eint__neg @ ( c_2Einteger_2Eint__rem @ V0p @ V1q ) ) )
        & ( ( c_2Einteger_2Eint__rem @ V0p @ ( c_2Einteger_2Eint__neg @ V1q ) )
          = ( c_2Einteger_2Eint__rem @ V0p @ V1q ) ) ) ) ).

thf(thm_2Einteger_2EINT__REM__ID,axiom,
    ! [V0p: tyop_2Einteger_2Eint] :
      ( ( (~)
        @ ( V0p
          = ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) ) )
     => ( ( c_2Einteger_2Eint__rem @ V0p @ V0p )
        = ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) ) ) ).

thf(thm_2Einteger_2EINT__REM0,axiom,
    ! [V0q: tyop_2Einteger_2Eint] :
      ( ( (~)
        @ ( V0q
          = ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) ) )
     => ( ( c_2Einteger_2Eint__rem @ ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) @ V0q )
        = ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) ) ) ).

thf(thm_2Einteger_2EINT__REM__COMMON__FACTOR,axiom,
    ! [V0p: tyop_2Einteger_2Eint] :
      ( ( (~)
        @ ( V0p
          = ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) ) )
     => ! [V1q: tyop_2Einteger_2Eint] :
          ( ( c_2Einteger_2Eint__rem @ ( c_2Einteger_2Eint__mul @ V1q @ V0p ) @ V0p )
          = ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) ) ) ).

thf(thm_2Einteger_2EINT__REM__EQ0,axiom,
    ! [V0q: tyop_2Einteger_2Eint] :
      ( ( (~)
        @ ( V0q
          = ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) ) )
     => ! [V1p: tyop_2Einteger_2Eint] :
          ( ( ( c_2Einteger_2Eint__rem @ V1p @ V0q )
            = ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) )
        <=> ? [V2k: tyop_2Einteger_2Eint] :
              ( V1p
              = ( c_2Einteger_2Eint__mul @ V2k @ V0q ) ) ) ) ).

thf(thm_2Einteger_2EINT__MUL__QUOT,axiom,
    ! [V0p: tyop_2Einteger_2Eint,V1q: tyop_2Einteger_2Eint,V2k: tyop_2Einteger_2Eint] :
      ( ( ( (~)
          @ ( V1q
            = ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) ) )
        & ( ( c_2Einteger_2Eint__rem @ V0p @ V1q )
          = ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) ) )
     => ( ( c_2Einteger_2Eint__quot @ ( c_2Einteger_2Eint__mul @ V2k @ V0p ) @ V1q )
        = ( c_2Einteger_2Eint__mul @ V2k @ ( c_2Einteger_2Eint__quot @ V0p @ V1q ) ) ) ) ).

thf(thm_2Einteger_2EINT__REM__EQ__MOD,axiom,
    ! [V0i: tyop_2Einteger_2Eint,V1n: tyop_2Einteger_2Eint] :
      ( ( c_2Einteger_2Eint__lt @ ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) @ V1n )
     => ( ( c_2Einteger_2Eint__rem @ V0i @ V1n )
        = ( c_2Ebool_2ECOND @ tyop_2Einteger_2Eint @ ( c_2Einteger_2Eint__lt @ V0i @ ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) ) @ ( c_2Einteger_2Eint__add @ ( c_2Einteger_2Eint__sub @ ( c_2Einteger_2Eint__mod @ ( c_2Einteger_2Eint__sub @ V0i @ ( c_2Einteger_2Eint__of__num @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) ) @ V1n ) @ V1n ) @ ( c_2Einteger_2Eint__of__num @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) ) @ ( c_2Einteger_2Eint__mod @ V0i @ V1n ) ) ) ) ).

thf(thm_2Einteger_2EINT__DIVIDES__MOD0,axiom,
    ! [V0p: tyop_2Einteger_2Eint,V1q: tyop_2Einteger_2Eint] :
      ( ( c_2Einteger_2Eint__divides @ V0p @ V1q )
    <=> ( ( ( ( c_2Einteger_2Eint__mod @ V1q @ V0p )
            = ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) )
          & ( (~)
            @ ( V0p
              = ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) ) ) )
        | ( ( V0p
            = ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) )
          & ( V1q
            = ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) ) ) ) ) ).

thf(thm_2Einteger_2EINT__DIVIDES__0,axiom,
    ( ! [V0x: tyop_2Einteger_2Eint] : ( c_2Einteger_2Eint__divides @ V0x @ ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) )
    & ! [V1x: tyop_2Einteger_2Eint] :
        ( ( c_2Einteger_2Eint__divides @ ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) @ V1x )
      <=> ( V1x
          = ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) ) ) ) ).

thf(thm_2Einteger_2EINT__DIVIDES__1,axiom,
    ! [V0x: tyop_2Einteger_2Eint] :
      ( ( c_2Einteger_2Eint__divides @ ( c_2Einteger_2Eint__of__num @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) @ V0x )
      & ( ( c_2Einteger_2Eint__divides @ V0x @ ( c_2Einteger_2Eint__of__num @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) )
      <=> ( ( V0x
            = ( c_2Einteger_2Eint__of__num @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) )
          | ( V0x
            = ( c_2Einteger_2Eint__neg @ ( c_2Einteger_2Eint__of__num @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) ) ) ) ) ) ).

thf(thm_2Einteger_2EINT__DIVIDES__REFL,axiom,
    ! [V0x: tyop_2Einteger_2Eint] : ( c_2Einteger_2Eint__divides @ V0x @ V0x ) ).

thf(thm_2Einteger_2EINT__DIVIDES__TRANS,axiom,
    ! [V0x: tyop_2Einteger_2Eint,V1y: tyop_2Einteger_2Eint,V2z: tyop_2Einteger_2Eint] :
      ( ( ( c_2Einteger_2Eint__divides @ V0x @ V1y )
        & ( c_2Einteger_2Eint__divides @ V1y @ V2z ) )
     => ( c_2Einteger_2Eint__divides @ V0x @ V2z ) ) ).

thf(thm_2Einteger_2EINT__DIVIDES__MUL,axiom,
    ! [V0p: tyop_2Einteger_2Eint,V1q: tyop_2Einteger_2Eint] :
      ( ( c_2Einteger_2Eint__divides @ V0p @ ( c_2Einteger_2Eint__mul @ V0p @ V1q ) )
      & ( c_2Einteger_2Eint__divides @ V0p @ ( c_2Einteger_2Eint__mul @ V1q @ V0p ) ) ) ).

thf(thm_2Einteger_2EINT__DIVIDES__LMUL,axiom,
    ! [V0p: tyop_2Einteger_2Eint,V1q: tyop_2Einteger_2Eint,V2r: tyop_2Einteger_2Eint] :
      ( ( c_2Einteger_2Eint__divides @ V0p @ V1q )
     => ( c_2Einteger_2Eint__divides @ V0p @ ( c_2Einteger_2Eint__mul @ V1q @ V2r ) ) ) ).

thf(thm_2Einteger_2EINT__DIVIDES__RMUL,axiom,
    ! [V0p: tyop_2Einteger_2Eint,V1q: tyop_2Einteger_2Eint,V2r: tyop_2Einteger_2Eint] :
      ( ( c_2Einteger_2Eint__divides @ V0p @ V1q )
     => ( c_2Einteger_2Eint__divides @ V0p @ ( c_2Einteger_2Eint__mul @ V2r @ V1q ) ) ) ).

thf(thm_2Einteger_2EINT__DIVIDES__MUL__BOTH,axiom,
    ! [V0p: tyop_2Einteger_2Eint,V1q: tyop_2Einteger_2Eint,V2r: tyop_2Einteger_2Eint] :
      ( ( (~)
        @ ( V0p
          = ( c_2Einteger_2Eint__of__num @ c_2Enum_2E0 ) ) )
     => ( ( c_2Einteger_2Eint__divides @ ( c_2Einteger_2Eint__mul @ V0p @ V1q ) @ ( c_2Einteger_2Eint__mul @ V0p @ V2r ) )
        = ( c_2Einteger_2Eint__divides @ V1q @ V2r ) ) ) ).

thf(thm_2Einteger_2EINT__DIVIDES__LADD,axiom,
    ! [V0p: tyop_2Einteger_2Eint,V1q: tyop_2Einteger_2Eint,V2r: tyop_2Einteger_2Eint] :
      ( ( c_2Einteger_2Eint__divides @ V0p @ V1q )
     => ( ( c_2Einteger_2Eint__divides @ V0p @ ( c_2Einteger_2Eint__add @ V1q @ V2r ) )
        = ( c_2Einteger_2Eint__divides @ V0p @ V2r ) ) ) ).

thf(thm_2Einteger_2EINT__DIVIDES__RADD,axiom,
    ! [V0p: tyop_2Einteger_2Eint,V1q: tyop_2Einteger_2Eint,V2r: tyop_2Einteger_2Eint] :
      ( ( c_2Einteger_2Eint__divides @ V0p @ V1q )
     => ( ( c_2Einteger_2Eint__divides @ V0p @ ( c_2Einteger_2Eint__add @ V2r @ V1q ) )
        = ( c_2Einteger_2Eint__divides @ V0p @ V2r ) ) ) ).

thf(thm_2Einteger_2EINT__DIVIDES__NEG,axiom,
    ! [V0p: tyop_2Einteger_2Eint,V1q: tyop_2Einteger_2Eint] :
      ( ( ( c_2Einteger_2Eint__divides @ V0p @ ( c_2Einteger_2Eint__neg @ V1q ) )
        = ( c_2Einteger_2Eint__divides @ V0p @ V1q ) )
      & ( ( c_2Einteger_2Eint__divides @ ( c_2Einteger_2Eint__neg @ V0p ) @ V1q )
        = ( c_2Einteger_2Eint__divides @ V0p @ V1q ) ) ) ).

thf(thm_2Einteger_2EINT__DIVIDES__LSUB,axiom,
    ! [V0p: tyop_2Einteger_2Eint,V1q: tyop_2Einteger_2Eint,V2r: tyop_2Einteger_2Eint] :
      ( ( c_2Einteger_2Eint__divides @ V0p @ V1q )
     => ( ( c_2Einteger_2Eint__divides @ V0p @ ( c_2Einteger_2Eint__sub @ V1q @ V2r ) )
        = ( c_2Einteger_2Eint__divides @ V0p @ V2r ) ) ) ).

thf(thm_2Einteger_2EINT__DIVIDES__RSUB,conjecture,
    ! [V0p: tyop_2Einteger_2Eint,V1q: tyop_2Einteger_2Eint,V2r: tyop_2Einteger_2Eint] :
      ( ( c_2Einteger_2Eint__divides @ V0p @ V1q )
     => ( ( c_2Einteger_2Eint__divides @ V0p @ ( c_2Einteger_2Eint__sub @ V2r @ V1q ) )
        = ( c_2Einteger_2Eint__divides @ V0p @ V2r ) ) ) ).

%------------------------------------------------------------------------------
